% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_fit.R
\name{fit_isothermal_inactivation}
\alias{fit_isothermal_inactivation}
\title{Fit of Isothermal Experiments}
\usage{
fit_isothermal_inactivation(model_name, death_data, starting_point,
  known_params, adjust_log = TRUE)
}
\arguments{
\item{model_name}{character specyfing the model to adjust.}

\item{death_data}{data frame with the experiment data where each row is one
observation. It must have the following columns:
\itemize{
  \item log_diff: Number of logarithmic reductions at each data point.
  \item temp: Temperature of the data point.
  \item time: Time of the data point.
  }}

\item{starting_point}{List with the initial values of the parameters
for the adjustment.}

\item{known_params}{List of the parameters of the model known.}

\item{adjust_log}{logical. If \code{TRUE}, the adjustment is based on the
minimization of the error of the logarithmic microbial count. If
\code{FALSE}, it is based on the minimization of the error of the
microbial count. \code{TRUE} by default.}
}
\value{
An instance of class \code{IsoFitInactivation} with the results.
        This list has four entries:
        \itemize{
          \item nls: The object of class \code{\link{nls}} with the results
                     of the adjustment.
          \item parameters: a list with the values of the model parameters,
                            both fixed and adjusted.
          \item model: a string with the key identifying the model used.
          \item data: the inactivation data used for the fit.
          }
}
\description{
Fits the parameters of the model chosen to a set of isothermal experiments
using nonlinear regression through the function \code{\link{nls}}.
}
\examples{
## EXAMPLE 1 -----------

data("isothermal_inactivation")  # data set used for the example.

get_isothermal_model_data()  # retrieve valid model keys.
model_name <- "Bigelow"  # Bigelow's model will be used for the adjustment.

model_data <- get_isothermal_model_data(model_name)
model_data$params  # Get the parameters of the model

## Define the input arguments

known_params = list(temp_ref = 100)
starting_point <- c(z = 10,D_R = 1)

## Call the fitting function
iso_fit <- fit_isothermal_inactivation(model_name,
                                       isothermal_inactivation, starting_point,
                                       known_params)

## Output of the results

plot(iso_fit, make_gg = TRUE)
goodness_of_fit(iso_fit)

## END EXAMPLE 1 --------

}
\seealso{
\code{\link{nls}}
}
