#' \pkg{biolink} makes it easy to link to online resources
#'
#' `biolink` provides functions for generating urls and hyperlinks to commonly
#' used biological databases and resources. This is primarily useful when
#' writing [dynamic reports](https://yihui.org/knitr/) that reference things
#' like gene symbols in text or tables, allowing you to, for example, convert
#' gene identifiers to hyperlinks pointing to their entry in the NCBI Gene
#' database.
#'
#' @section Notable features:
#'
#' * generate valid hyperlinks for LaTex, HTML and Markdown documents
#' * hyperlink text and title attributes can be specified (where possible)
#' * *data tags* can be used to insert certain kinds of information from
#' select databases
#'
#' @seealso the [annotate](https://bioconductor.org/packages/annotate) package
#'   from Bioconductor
#'
#' @name biolink
#' @docType package
NULL
