% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listKingdoms.R
\name{listKingdoms}
\alias{listKingdoms}
\title{List number of available genomes in each kingdom of life}
\usage{
listKingdoms(db = "refseq")
}
\arguments{
\item{db}{a character string specifying the database for which genome availability shall be checked, 
e.g. \code{db = "refseq"}, \code{db = "genbank"}, \code{db = "ensembl"}, \code{db = "ensemblgenomes"}.}
}
\description{
Users can retrieve the available number of sequenced genomes per kingdom.
}
\examples{

\dontrun{
# list number of available genomes in refseq for each kingdom of life
listKingdoms(db = "refseq")

# example for genbank
listKingdoms(db = "genbank")

# example for ensembl
listKingdoms(db = "ensembl")

# example for ensemblgenomes
listKingdoms(db = "ensemblgenomes")
}

}
\seealso{
\code{\link{listGenomes}}, \code{\link{is.genome.available}}, \code{\link{listGroups}}, \code{\link{listSubgroups}}
}
\author{
Hajk-Georg Drost
}
