% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_1.R
\docType{class}
\name{BIOMOD.formated.data}
\alias{BIOMOD.formated.data}
\alias{BIOMOD.formated.data-class}
\alias{BIOMOD.formated.data,numeric,data.frame-method}
\alias{BIOMOD.formated.data,data.frame,ANY-method}
\alias{BIOMOD.formated.data,numeric,matrix-method}
\alias{BIOMOD.formated.data,numeric,SpatRaster-method}
\alias{show,BIOMOD.formated.data-method}
\title{\code{BIOMOD_FormatingData()} output object class}
\usage{
\S4method{BIOMOD.formated.data}{numeric,data.frame}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  na.rm = TRUE,
  data.mask = NULL,
  shared.eval.env = FALSE,
  filter.raster = FALSE
)

\S4method{BIOMOD.formated.data}{data.frame,ANY}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  na.rm = TRUE,
  filter.raster = FALSE
)

\S4method{BIOMOD.formated.data}{numeric,matrix}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  na.rm = TRUE,
  filter.raster = FALSE
)

\S4method{BIOMOD.formated.data}{numeric,SpatRaster}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  na.rm = TRUE,
  shared.eval.env = FALSE,
  filter.raster = FALSE
)

\S4method{show}{BIOMOD.formated.data}(object)
}
\arguments{
\item{sp}{A \code{vector}, a \code{\link[terra:vect]{SpatVector}} without associated 
data (\emph{if presence-only}), or a \code{\link[terra:vect]{SpatVector}}
object containing binary data (\code{0} : absence,  \code{1} : presence,
\code{NA} : indeterminate) for a single species that will be used to 
build the species distribution model(s)
\cr \emph{Note that old format from \pkg{sp} are still supported such as
 \code{SpatialPoints}  (if presence-only) or \code{SpatialPointsDataFrame}
 object containing binary data.}}

\item{env}{a \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}}
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables 
(in columns or layers) that will be used to build the species distribution model(s).
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still supported such as 
\code{RasterStack} and \code{SpatialPointsDataFrame} objects. }}

\item{xy}{(\emph{optional, default} \code{NULL}) \cr 
If \code{resp.var} is a \code{vector}, a 2-columns \code{matrix} or \code{data.frame} 
containing the corresponding \code{X} and \code{Y} coordinates that will be used to build the 
species distribution model(s)}

\item{dir.name}{a \code{character} corresponding to the modeling folder}

\item{sp.name}{a \code{character} corresponding to the species name}

\item{eval.sp}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector}, a \code{\link[terra:vect]{SpatVector}} without associated 
data (\emph{if presence-only}), or a \code{\link[terra:vect]{SpatVector}}
object containing binary data (\code{0} : absence, \code{1} : presence, 
\code{NA} : indeterminate) for a single species that will be used to
evaluate the species distribution model(s) with independent data
\cr \emph{Note that old format from \pkg{sp} are still supported such as
\code{SpatialPoints}  (if presence-only) or \code{SpatialPointsDataFrame}
object containing binary data.}}

\item{eval.env}{(\emph{optional, default} \code{NULL}) \cr 
A \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}} or
\code{\link[terra:rast]{SpatRaster}} object containing the explanatory
variables (in columns or layers) that will be used to evaluate the species
distribution model(s) with independent data
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still
supported such as \code{RasterStack} and \code{SpatialPointsDataFrame}
objects. }}

\item{eval.xy}{(\emph{optional, default} \code{NULL}) \cr 
If \code{resp.var} is a \code{vector}, a 2-columns \code{matrix} or
\code{data.frame} containing the corresponding \code{X} and \code{Y}
coordinates that will be used to evaluate the species distribution model(s)
with independent data}

\item{na.rm}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether points having one or several missing
values for explanatory variables should be removed from the analysis or not}

\item{data.mask}{(\emph{optional, default} \code{NULL}) \cr 
A \code{\link[terra:rast]{SpatRaster}} object containing the mask of the studied area}

\item{shared.eval.env}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether the explanatory variables used for the 
evaluation dataset are the same than the ones for calibration (if \code{eval.env} not 
provided for example) or not}

\item{filter.raster}{(\emph{optional, default} \code{FALSE}) \cr 
If \code{env} is of raster type, a \code{logical} value defining whether \code{sp} 
is to be filtered when several points occur in the same raster cell}

\item{object}{a \code{\link{BIOMOD.formated.data}} object}
}
\description{
Class returned by \code{\link{BIOMOD_FormatingData}}, and used by 
\code{\link{BIOMOD_Tuning}}, \code{\link{bm_CrossValidation}} and 
\code{\link{BIOMOD_Modeling}}
}
\section{Slots}{

\describe{
\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{coord}}{a 2-columns \code{data.frame} containing the corresponding \code{X} and \code{Y} 
coordinates}

\item{\code{data.species}}{a \code{vector} containing the species observations (\code{0}, \code{1} or 
\code{NA})}

\item{\code{data.env.var}}{a \code{data.frame} containing explanatory variables}

\item{\code{data.mask}}{a \code{\link[terra:rast]{SpatRaster}} object containing the mask of the 
studied area}

\item{\code{has.data.eval}}{a \code{logical} value defining whether evaluation data is given}

\item{\code{eval.coord}}{(\emph{optional, default} \code{NULL}) \cr 
A 2-columns \code{data.frame} containing the corresponding \code{X} and \code{Y} 
coordinates for evaluation data}

\item{\code{eval.data.species}}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing the species observations (\code{0}, \code{1} or \code{NA}) for 
evaluation data}

\item{\code{eval.data.env.var}}{(\emph{optional, default} \code{NULL}) \cr 
A \code{data.frame} containing explanatory variables for evaluation data}
}}

\examples{

showClass("BIOMOD.formated.data")

## ----------------------------------------------------------------------- #
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                     expl.var = myExpl,
                                     resp.xy = myRespXY,
                                     resp.name = myRespName)
myBiomodData
plot(myBiomodData)
summary(myBiomodData)


}
\seealso{
\code{\link{BIOMOD_FormatingData}}, \code{\link{BIOMOD_Tuning}}, 
\code{\link{bm_CrossValidation}}, \code{\link{BIOMOD_Modeling}}, 
\code{\link{bm_RunModelsLoop}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
