% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.overlaps.R
\name{heatmap.overlaps}
\alias{heatmap.overlaps}
\title{Plot heatmat}
\usage{
heatmap.overlaps(x, legend = NA, xlab = NA, ylab = NA, col = NA,
  lim = NA, x.axis.angle = 90)
}
\arguments{
\item{x}{A matrix object or a list object with two-levels.}

\item{legend}{A legend for colors.}

\item{xlab}{A label for the x axis.}

\item{ylab}{A label for the y axis.}

\item{col}{A character vector of colors. Default is Spectral color
palette in RColorBrewer package.}

\item{lim}{A range of values.}

\item{x.axis.angle}{A angle for labels in x axis. Default is 90 degrees.}
}
\value{
ggplot class object
}
\description{
Plot heatmat to visualize multiple Venn diagram.
}
\examples{
mat <- matrix(rnbinom(135, size = 10, prob = 0.2), nrow = 15, ncol = 9)
colnames(mat) <- paste0("Treat", 1:9)
rownames(mat) <- c("a", "b", "c", "d", "ab", "ac", "ad", "bc", "bd", "cd",
                   "abc", "abd", "acd", "bcd", "abcd")
head(mat)

heatmap.overlaps(mat)


}

