% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformG_selection.R
\name{uniformG_selection}
\alias{uniformG_selection}
\title{Selection of survey sites maximizing uniformity in geography}
\usage{
uniformG_selection(master, expected_points, guess_distances = TRUE,
                   initial_distance = NULL, increase = NULL,
                   max_n_samplings = 1, replicates = 10,
                   use_preselected_sites = TRUE,
                   median_distance_filter = NULL, set_seed = 1,
                   verbose = TRUE, force = FALSE)
}
\arguments{
\item{master}{master_matrix object derived from function
\code{\link{prepare_master_matrix}} or master_selection object derived
from functions \code{\link{random_selection}},
\code{\link{uniformE_selection}}, or \code{\link{EG_selection}}.}

\item{expected_points}{(numeric) number of survey points (sites) to be
selected.}

\item{guess_distances}{(logical) whether or not to use internal algorithm
to select automatically \code{initial_distance} and \code{increase}. Default
= TRUE. If FALSE, \code{initial_distance} and \code{increase} must be
defined.}

\item{initial_distance}{(numeric) distance in km to be used for a first
process of thinning and detection of remaining points. Default = NULL.}

\item{increase}{(numeric) initial value to be added to or subtracted from
\code{initial_distance} until reaching the number of \code{expected_points}.
Default = NULL.}

\item{max_n_samplings}{(numeric) maximum number of samples to be chosen
after performing all thinning \code{replicates}. Default = 1.}

\item{replicates}{(numeric) number of thinning replicates. Default = 10.}

\item{use_preselected_sites}{(logical) whether to use sites that have been
defined as part of the selected sites previous any selection. Object in
\code{master} must contain the site(s) preselected in and element of name
"preselected_sites" for this argument to be effective. Default = TRUE.
See details for more information on the approach used.}

\item{median_distance_filter}{(character) optional argument to define a
median distance-based filter based on which sets of sampling sites will be
selected. The default, NULL, does not apply such a filter. Options are:
"max" and "min".}

\item{set_seed}{(numeric) integer value to specify an initial seed.
Default = 1.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}

\item{force}{(logical) whether to replace existing set of sites selected
with this method in \code{master}.}
}
\value{
A \code{\link{master_selection}} object (S3) with an element
called selected_sites_G containing one or more sets of selected sites.
}
\description{
Selection of sites to be sampled in a survey, with the goal of
maximizing uniformity of points in geographic space.
}
\details{
Survey sites are selected searching for maximum geographic distances among
all sites. This approach helps in selecting points that can cover most of
the geographic extent of the region of interest. This type of selection
could be appropriate when the region of interest has a complex geographic
pattern (e.g., an archipelago). This type of selection does not consider
environmental conditions in the region of interest, which is why important
environmental combinations may not be represented in the final selection of
sites.

Exploring the geographic and environmental spaces of the region of interest
would be a crucial first step before selecting survey sites. Such
explorations can be done using the function \code{\link{explore_data_EG}}.

If \code{use_preselected_sites} = TRUE and such sites are included as an
element in the object in \code{master}, the approach for selecting uniform
sites in geography is different than what was described above.
User-preselected sites will always be part of the sites selected. Other
points are selected based on an algorithm that searches for sites that are
uniformly distributed in geographic space but at a distance from preselected
sites that helps in maintaining uniformity. Note that preselected sites will
not be processed; therefore, uniformity of such points cannot be warrantied.

As multiple sets could result from selection when the
\code{use_preselected_sites} is set as FALSE, the argument of the function
\code{median_distance_filter} could be used to select the set of sites with
the maximum ("max") or minimum ("min") median distance among selected sites.
The option "max" will increase the geographic distance among sampling sites,
which could be desirable if the goal is to cover the region of interest more
broadly. The other option, "min", could be used in cases when the goal is to
reduce resources and time needed to sample such sites.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

# Selecting sites uniformly in G space
selectionG <- uniformG_selection(m_matrix, expected_points = 40,
                                 max_n_samplings = 1, replicates = 5)
}
\seealso{
\code{\link{random_selection}}, \code{\link{uniformE_selection}},
\code{\link{EG_selection}}, \code{\link{plot_sites_EG}}
}
