% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/short_helpers.R
\name{legend_bar}
\alias{legend_bar}
\title{Helper to add a bar image legend to plots}
\usage{
legend_bar(position, col, width_prop = 0.03, heigh_prop = 0.18,
           title = "Legend", labels = c("Low", "High"), digits = 0,
           labels_offset = 0.2, horizontal = FALSE, alpha = 1, border = NULL,
           cex = NULL, inset = 0.05, insetx = NULL, insety = NULL)
}
\arguments{
\item{position}{(numeric or character) position of the bottom left corner of
the legend. If numeric, x and y coordinates. If character, options are:
"bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright",
"right", or "center".}

\item{col}{color palette. A vector of contiguous colors. It can be generated
using functions like \code{\link{purplow}} (e.g., \code{darkros(255)}).}

\item{width_prop}{width of bar legend represented as a proportion of the
entire plotting width. Default = 0.03.}

\item{heigh_prop}{heigh of bar legend represented as a proportion of the
entire plotting heigh. Default = 0.18.}

\item{title}{legend title. Default = "Legend".}

\item{labels}{(numeric or character) labels for the legend. Default =
c("Low", "High").}

\item{digits}{(numeric) number of decimal places to round numeric labels.
Default = 0.}

\item{labels_offset}{offset of labels from bar. Default = 0.2.}

\item{horizontal}{(logical) should the legend be horizontal. Default = FALSE.}

\item{alpha}{(numeric) alpha level 0-1. Default = 1.}

\item{border}{color for the border of the legend bar. The default, NULL, does
not plot a border.}

\item{cex}{character expansion factor relative to current.
Default = NULL.}

\item{inset}{inset distances from plot margins relative to plot region.
Default = 0.05.}

\item{insetx}{inset from x margins. The default, NULL, uses \code{inset}.}

\item{insety}{inset from y margins. The default, NULL, uses \code{inset}.}
}
\value{
A bar legend for a plot.
}
\description{
Helper to add a bar image legend to plots
}
