% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam_helpers.R
\name{stack_2data}
\alias{stack_2data}
\title{Creates a data.frame of species' references from RasterStack}
\usage{
stack_2data(species_layers)
}
\arguments{
\item{species_layers}{RasterStack or RasterBrick object. Each layer must be
named as the species that it represents, and values in each layer must be
1 (presence) and 0 (absence).}
}
\value{
A data.frame of species geographic records derived from values of presence
in each layer from the RasterStack.
}
\description{
Creates a data.frame of species' references that contains
longitude, latitude, and species name, using a RasterStack or a RasterBrick
as input.
}
\examples{
# Data
rsp <- raster::stack(system.file("extdata/sp_layers.tif",
                                 package = "biosurvey"))
names(rsp) <- paste0("Species_", 1:5)

# Species data from RasterStack
sp_data <- stack_2data(species_layers = rsp)
summary(sp_data)
}
