% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/short_helpers.R
\name{wgs84_2aed_laea}
\alias{wgs84_2aed_laea}
\title{Project spatial points from geographic coordinates}
\usage{
wgs84_2aed_laea(data, longitude, latitude, which = "ED")
}
\arguments{
\item{data}{matrix or data.frame that contains at least two columns, one
with longitude information and the other with latitude information.}

\item{longitude}{(character) the name of the column that contains the
longitude information.}

\item{latitude}{(character) the name of the column that contains the latitude
information.}

\item{which}{(character) type of projection. There are two options available:
"ED", for Azimuthal Equidistant and "EA", for Lambert Azimuthal Equal-Area.
Default = "ED".}
}
\value{
SpatialPointsDataFrame projected to an option in \code{which}.
}
\description{
Project spatial points from geographic coordinates
}
\examples{
data("sp_occurrences", package = "biosurvey")

sp_occ <- wgs84_2aed_laea(sp_occurrences, longitude = "longitude",
                          latitude = "latitude", which = "EA")
}
