% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobians.R
\name{jac.logit}
\alias{jac.logit}
\title{Jacobian for logit transform}
\usage{
jac.logit(x, log = TRUE, range = c(0, 1))
}
\arguments{
\item{x}{value at which to evaluate \eqn{J(x)}}

\item{log}{TRUE to return \eqn{log(J(x))}}

\item{range}{vector specifying min and max range of the closed interval for 
the logit.  While the logit is defined for real numbers in the unit 
interval, we extend it to real numbers in arbitrary closed intervals (L,U).}
}
\description{
Let \eqn{X=logit(Y)} be a transformation of a random variable \eqn{Y} that 
lies in the closed interval (L,U).  
This function computes the jacobian \eqn{J(x)} when using the density of 
\eqn{Y} to evaluate the density of \eqn{X} via
\deqn{f(x) = f_y(logit^{-1}(x) * (U-L) + L) J(x)}
where 
\deqn{J(x) = (U-L) d/dx logit^{-1}(x).}
}
\examples{
jac.logit(1)

}
