% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logjac.R
\name{logjac}
\alias{logjac}
\title{Wrapper to abstractly evaluate log-Jacobian functions for transforms}
\usage{
logjac(x, link, linkparams)
}
\arguments{
\item{x}{values at which to evaluate \eqn{J(x)}}

\item{link}{Character vector specifying link function for which the 
inverse link function should be evaluated.  Supports \code{'identity'},
\code{'log'}, and \code{'logit'}.}

\item{linkparams}{Optional list of additional parameters  for link functions.
For example, the logit function can be extended to allow mappings to any 
closed interval.  There should be one list entry for each link function.  
Specify NA if defaults should be used.}
}
\description{
Wrapper to abstractly evaluate log-Jacobian functions for transforms
}
\examples{
bisque:::logjac(1, 'logit', list(NA))

}
\seealso{
\code{\link{jac.log}}, \code{\link{jac.logit}}
}
