% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{booltype}
\alias{booltype}
\title{Diagnosing boolean types}
\usage{
booltype(x)
}
\arguments{
\item{x}{an R object}
}
\value{
one scalar element of \code{\link{booltypes}} in case of 'nobool' it carries a name attribute with the data type.
}
\description{
Specific methods for \code{booltype} are required, where non-unary methods can combine multiple bollean types, particularly boolean binary operators.
}
\details{
Function \code{booltype} returns the boolean type of its argument.
There are currently six boolean types, \code{booltypes} is an \code{\link{ordered}} vector with the following ordinal \code{\link{levels}} \describe{
\item{nobool}{non-boolean types}
\item{\code{\link{logical}}}{for representing any boolean data including \code{NA} }
\item{\code{\link{bit}}}{for representing dense boolean data }
\item{\code{\link{bitwhich}}}{for representing sparse (skewed) boolean data  }
\item{\code{\link{which}}}{for representing sparse boolean data with few \code{TRUE}}
\item{\code{\link{ri}}}{range-indexing, for representing sparse boolean data with a single range of \code{TRUE} }
}
}
\note{
do not rely on the internal integer codes of these levels, we might add-in \code{\link[ff]{hi}} later
}
\examples{
unname(booltypes)
str(booltypes)
sapply(list(double(),integer(),logical(),bit(),bitwhich(),as.which(),ri(1,2,3)), booltype)
}
\seealso{
\code{\link{booltypes}}, \code{\link{is.booltype}}, \code{\link{as.booltype}}
}
