% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{cbind.bm_bitmap}
\alias{cbind.bm_bitmap}
\alias{rbind.bm_bitmap}
\title{Combine bitmaps by rows or columns}
\usage{
\method{cbind}{bm_bitmap}(..., direction = "left-to-right", vjust = "center-top")

\method{rbind}{bm_bitmap}(..., direction = "top-to-bottom", hjust = "center-left")
}
\arguments{
\item{...}{\code{\link[=bm_bitmap]{bm_bitmap()}} objects.}

\item{direction}{For \verb{cbind().bm_bitmap} either "left-to-right" (default) or its aliases "ltr" and "lr"
OR "right-to-left" or its aliases "rtl" and "rl".
For \verb{rbind().bm_bitmap} either "top-to-bottom" (default) or its aliases "ttb" and "tb"
OR "bottom-to-top" or its aliases "btt" and "bt".
The \code{direction} argument is not case-sensitive.}

\item{vjust}{Used by \code{\link[=bm_extend]{bm_extend()}} if bitmap heights are different.}

\item{hjust}{Used by \code{\link[=bm_extend]{bm_extend()}} if bitmap widths are different.}
}
\value{
A \code{\link[=bm_bitmap]{bm_bitmap()}} object.
}
\description{
\code{cbind.bm_bitmap()} and \code{rbind.bm_bitmap()} combine
by columns or rows respectively.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  capital_b <- font[[str2ucp("B")]]
  capital_m <- font[[str2ucp("M")]]
  cbm <- cbind(capital_b, capital_m)
  print(cbm, px = c(".", "#"))
  cbm_rl <- cbind(capital_b, capital_m, direction = "right-to-left")
  print(cbm_rl, px = c(".", "#"))
  rbm <- rbind(capital_b, capital_m)
  print(rbm, px = c(".", "#"))
  rbm_bt <- rbind(capital_b, capital_m, direction = "bottom-to-top")
  print(rbm_bt, px = c(".", "#"))
}
