% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bizseq.R
\name{bizseq}
\alias{bizseq}
\title{Create a sequence of business days}
\usage{
bizseq(from, to, cal)
}
\arguments{
\item{from}{the initial date}

\item{to}{the final date (must be greater than \code{from})}

\item{cal}{the calendar's name}
}
\value{
A vector of \code{Date} objects that are business days according to the
provided \code{Calendar}.
}
\description{
Returns a sequence of dates with business days only.
}
\section{Date types accepted}{


The arguments \code{from} and \code{to} accept \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}
\examples{
create.calendar("Brazil/ANBIMA", holidaysANBIMA, weekdays=c("saturday", "sunday"))
bizseq("2013-01-02", "2013-01-31", "Brazil/ANBIMA")

}

