
# This file is automatically generated, you probably don't want to edit this

jamoviBAanalysisOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "jamoviBAanalysisOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            method1 = NULL,
            method2 = NULL,
            ciDisplay = TRUE,
            ciShading = TRUE,
            plotProportionalBias = FALSE,
            plotProportionalBias.se = TRUE,
            overlapping = FALSE, ...) {

            super$initialize(
                package='blandr',
                name='jamoviBAanalysis',
                requiresData=TRUE,
                ...)

            private$..method1 <- jmvcore::OptionVariable$new(
                "method1",
                method1,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..method2 <- jmvcore::OptionVariable$new(
                "method2",
                method2,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..ciDisplay <- jmvcore::OptionBool$new(
                "ciDisplay",
                ciDisplay,
                default=TRUE)
            private$..ciShading <- jmvcore::OptionBool$new(
                "ciShading",
                ciShading,
                default=TRUE)
            private$..plotProportionalBias <- jmvcore::OptionBool$new(
                "plotProportionalBias",
                plotProportionalBias,
                default=FALSE)
            private$..plotProportionalBias.se <- jmvcore::OptionBool$new(
                "plotProportionalBias.se",
                plotProportionalBias.se,
                default=TRUE)
            private$..overlapping <- jmvcore::OptionBool$new(
                "overlapping",
                overlapping,
                default=FALSE)

            self$.addOption(private$..method1)
            self$.addOption(private$..method2)
            self$.addOption(private$..ciDisplay)
            self$.addOption(private$..ciShading)
            self$.addOption(private$..plotProportionalBias)
            self$.addOption(private$..plotProportionalBias.se)
            self$.addOption(private$..overlapping)
        }),
    active = list(
        method1 = function() private$..method1$value,
        method2 = function() private$..method2$value,
        ciDisplay = function() private$..ciDisplay$value,
        ciShading = function() private$..ciShading$value,
        plotProportionalBias = function() private$..plotProportionalBias$value,
        plotProportionalBias.se = function() private$..plotProportionalBias.se$value,
        overlapping = function() private$..overlapping$value),
    private = list(
        ..method1 = NA,
        ..method2 = NA,
        ..ciDisplay = NA,
        ..ciShading = NA,
        ..plotProportionalBias = NA,
        ..plotProportionalBias.se = NA,
        ..overlapping = NA)
)

jamoviBAanalysisResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$.items[["table"]],
        plot = function() private$.items[["plot"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Bland-Altman Analysis")
            self$add(jmvcore::Table$new(
                options=options,
                name="table",
                title="Bland-Altman",
                rows=3,
                clearWith=list(
                    "method1",
                    "method2"),
                columns=list(
                    list(
                        `name`="table_row_names", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="estimate", 
                        `title`="Estimate", 
                        `type`="number"),
                    list(
                        `name`="LowerCI", 
                        `superTitle`="95% Confidence Interval", 
                        `title`="Lower", 
                        `type`="number"),
                    list(
                        `name`="UpperCI", 
                        `superTitle`="95% Confidence Interval", 
                        `title`="Upper", 
                        `type`="number"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="plot",
                width=600,
                height=450,
                renderFun=".plot"))}))

jamoviBAanalysisBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "jamoviBAanalysisBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'blandr',
                name = 'jamoviBAanalysis',
                version = c(1,0,0),
                options = options,
                results = jamoviBAanalysisResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Bland-Altman Analysis
#'
#' 
#' @param data .
#' @param method1 .
#' @param method2 .
#' @param ciDisplay .
#' @param ciShading .
#' @param plotProportionalBias .
#' @param plotProportionalBias.se .
#' @param overlapping .
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$table} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$table$asDF}
#'
#' \code{as.data.frame(results$table)}
#'
#' @export
jamoviBAanalysis <- function(
    data,
    method1,
    method2,
    ciDisplay = TRUE,
    ciShading = TRUE,
    plotProportionalBias = FALSE,
    plotProportionalBias.se = TRUE,
    overlapping = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('jamoviBAanalysis requires jmvcore to be installed (restart may be required)')

    options <- jamoviBAanalysisOptions$new(
        method1 = method1,
        method2 = method2,
        ciDisplay = ciDisplay,
        ciShading = ciShading,
        plotProportionalBias = plotProportionalBias,
        plotProportionalBias.se = plotProportionalBias.se,
        overlapping = overlapping)

    results <- jamoviBAanalysisResults$new(
        options = options)

    analysis <- jamoviBAanalysisClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
