% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_test_message.R
\name{prepare_test_message}
\alias{prepare_test_message}
\title{Prepare a email test message object}
\usage{
prepare_test_message(incl_ggplot = FALSE, incl_image = FALSE)
}
\arguments{
\item{incl_ggplot}{An option to include a ggplot plot within the body of the
test message. This requires that the \pkg{ggplot2} package is installed. By
default, this is \code{FALSE}.}

\item{incl_image}{An option to include a test image within the body of the
test message. By default, this is \code{FALSE}.}
}
\value{
An \code{email_message} object.
}
\description{
Create an email test message object, which is helpful for sending a test
message with the \code{smtp_send()} function.
}
\examples{
# Create a credentials file to send
# a test message via Gmail's SMTP
# (this file is named "gmail_secret")

# create_smtp_creds_file(
#   file = "gmail_secret",
#   user = "sender@email.com",
#   provider = "gmail"
# )

# Send oneself a test message to
# test these new SMTP settings and
# to ensure that the message appears
# correctly in the email client

# prepare_test_message() \%>\%
#   smtp_send(
#     from = "sender@email.com",
#     to = "sender@email.com",
#     subject = "Test Message",
#     credentials = creds_file(
#       file = "gmail_secret"
#       )
#     )

}
