% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcpd.R
\name{rcpd}
\alias{rcpd}
\title{Sampler for the CPD Block Model}
\usage{
rcpd(
  nrow = 100,
  ncol = 50,
  ncp = 1,
  family = "bernoulli",
  parameters = NULL,
  changepoints = NULL,
  prob_NA = 0
)
}
\arguments{
\item{nrow}{Number of rows, or sample size, of the data.}

\item{ncol}{Number of columns of data matrix. It is the number of variables for
each sample.}

\item{ncp}{Number of change points.  The number of blocks is \eqn{ncp + 1}.
It is overridden if changepoints is non-NULL.}

\item{family}{The family model to be sampled. The families currently
implemented are:

\itemize{
\item bernoulli: Sample independent Bernoullis with probability parameter
of the block
\item normal: Sample independent Normal with mean and variance specified
by the block.
\item binaryMarkov: Samples a two state Markov Chain process with transition
matrix defined by the block.
\item exponential: Sample independent Exponential with scale parameter
defined by the block.
\item poisson: Sample independent Poisson with rate parameter defined
by the block.
}}

\item{parameters}{List of parameters containing \eqn{ncp + 1} dimensional
parameter vectors of each block. If NULL, the parameters are sampled
randomly.}

\item{changepoints}{A sorted vector of size \eqn{ncp} containing integers as
change point locations. The change points are between 1 and \eqn{ncol-1}. If
NULL, the change points are sampled uniformly in \eqn{[1, ncol-1]}.}

\item{prob_NA}{Probability of each entry of being NA. Default is 0.}
}
\value{
Returns a list containing 3 elements:
#' \itemize{
\item{"data_matrix"} A matrix containing the data.
\item{"changepoints"} A numeric vector containing the change-point locations
\item{"parameters"} A list whose keys are the parameters names and the
values are vectors containing the parameter for each block.
}
}
\description{
Creates a \eqn{nrow \times ncol} matrix with \eqn{ncp} change points.
In between change points, the random variables are i.i.d. sampled from the
given family and parameters
}
\examples{
td = rcpd(nrow = 20, ncol = 10) # 20 Bernoulli series of size 10 with 1 change-point
td = rcpd(nrow = 10, ncol = 100, ncp = 5,
          family = "normal") # 10 normal series of size 100 with 5 change-points
td = rcpd(nrow = 1000, ncol = 100, changepoints = c(10, 40, 79)) # choosing change-points locations
td = rcpd(nrow = 100, ncol = 15, ncp = 2, family = "normal",
          parameters = list(mean = c(1, 2, 3), var = c(4, 5, 6))) # choosing parameters
}
