% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockseg-class.R
\docType{class}
\name{blockSeg-class}
\alias{blockSeg-class}
\alias{deviance,blockSeg-method}
\alias{getBreaks}
\alias{getBreaks,blockSeg-method}
\alias{getComplexity}
\alias{getComplexity,blockSeg-method}
\alias{getCompressYhat}
\alias{getCompressYhat,blockSeg-method}
\alias{print,blockSeg-method}
\alias{residuals,blockSeg-method}
\alias{show,blockSeg-method}
\title{Class "blockSeg"}
\usage{
\S4method{print}{blockSeg}(x, ...)

\S4method{show}{blockSeg}(object)

getComplexity(object)

\S4method{getComplexity}{blockSeg}(object)

\S4method{residuals}{blockSeg}(object, Y)

\S4method{deviance}{blockSeg}(object, Y)

getBreaks(object)

\S4method{getBreaks}{blockSeg}(object)

getCompressYhat(object, Y)

\S4method{getCompressYhat}{blockSeg}(object, Y)
}
\arguments{
\item{x}{in the print method, a blockSeg object}

\item{...}{in the print method, additional parameters (ignored)}

\item{object}{an object with class blockSeg}

\item{Y}{the original data matrix}
}
\description{
Class of object returned by the \code{blockSeg} function.
}
\section{Slots}{

\describe{
\item{\code{Beta}}{a Matrix object of type \code{dgCMatrix},
encoding the solution path of the underlying LARS algorithm. Ommited
if the blockSeg function was called with the option
\code{Beta=FALSE}.}

\item{\code{Lambda}}{a numeric vector with the successive values
of \code{Lambda}, that is, the value of the penalty parameter
corresponding to a new event in the path (either a variable
activation or deactivation).}

\item{\code{RowBreaks}}{a list of vectors, one per step of the 
LARS algorithm. Each vector contains the breaks currently identified
along the ROWS of the 2-dimensional signalat the current step.}

\item{\code{ColBreaks}}{a list of vectors, one per step of the
LARS algorithm. Each vector contains the breaks currently identified
along the COLUMNS of the 2-dimensional signal at the current step.}

\item{\code{Actions}}{a list with the successive actions at each
step of the LARS algorithm.}
}}
\seealso{
See also \code{\link{plot,blockSeg-method}}, \code{\link{predict,blockSeg-method}}
and \code{\link{blockSeg}}.
}

