% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{md5sum_filter}
\alias{md5sum_filter}
\alias{timestamp_filter}
\title{Look for files that have been possibly modified}
\usage{
md5sum_filter(files, db = "blogdown/md5sum.txt")

timestamp_filter(files)
}
\arguments{
\item{files}{A vector of file paths.}

\item{db}{Path to the database file.}
}
\value{
Paths of files of which the checksums have changed.
}
\description{
Filter files by checking if their modification times or MD5 checksums have
changed.
}
\details{
The function \code{md5sum_filter()} reads the MD5 checksums of files from a
database (a tab-separated text file), and returns the files of which the
checksums have changed. If the database does not exist, write the checksums
of files to it, otherwise update the checksums after the changed files have
been identified. When a file is modified, its MD5 checksum is very likely to
change.

The function \code{timestamp_filer()} compares the modification time of an
Rmd file with that of its output file, and returns a file if it's newer than
its output file by \code{N} seconds (or if the output file does not exist),
where \code{N} is obtained from the R global option
\code{blogdown.time_diff}. By default, \code{N = 0}. You may change it via
\code{options()}, e.g., \code{options(blogdown.time_diff = 5)} means an Rmd
file will be returned when its modification time at least 5 seconds newer
than its output file's modification time.

These functions can be used to determine which Rmd files to be rebuilt in a
\pkg{blogdown} website. See \code{\link{build_site}()} for more information.
}
