% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-validation.R
\name{blr_confusion_matrix}
\alias{blr_confusion_matrix}
\title{Confusion matrix}
\usage{
blr_confusion_matrix(model, cutoff = 0.5, data = NULL)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{cutoff}{Cutoff for classification.}

\item{data}{A \code{tibble} or a \code{data.frame}.}
}
\value{
Confusion matix.
}
\description{
Wrapper for \code{confMatrix} from the caret package.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_confusion_matrix(model, cutoff = 0.4)

}
\seealso{
Other model validation techniques: \code{\link{blr_decile_capture_rate}},
  \code{\link{blr_decile_lift_chart}},
  \code{\link{blr_gains_table}},
  \code{\link{blr_gini_index}}, \code{\link{blr_ks_chart}},
  \code{\link{blr_lorenz_curve}},
  \code{\link{blr_roc_curve}},
  \code{\link{blr_test_hosmer_lemeshow}}
}
