% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-bivariate-analysis.R
\name{blr_segment_dist}
\alias{blr_segment_dist}
\alias{plot.blr_segment_dist}
\title{Response distribution}
\usage{
blr_segment_dist(data, response, predictor)

\method{plot}{blr_segment_dist}(
  x,
  title = NA,
  xaxis_title = "Levels",
  yaxis_title = "Sample Distribution",
  sec_yaxis_title = "1s Distribution",
  bar_color = "blue",
  line_color = "red",
  print_plot = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{tibble} or a \code{data.frame}.}

\item{response}{Response variable; column in \code{data}.}

\item{predictor}{Predictor variable; column in \code{data}.}

\item{x}{An object of class \code{blr_segment_dist}.}

\item{title}{Plot title.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{sec_yaxis_title}{Secondary y axis title.}

\item{bar_color}{Bar color.}

\item{line_color}{Line color.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{Other inputs.}
}
\value{
A tibble.
}
\description{
Distribution of response variable by segements/levels of a qualitative variable.
}
\examples{
k <- blr_segment_dist(hsb2, honcomp, prog)
k

# plot
plot(k)

}
\seealso{
Other bivariate analysis procedures: 
\code{\link{blr_bivariate_analysis}()},
\code{\link{blr_segment_twoway}()},
\code{\link{blr_segment}()},
\code{\link{blr_woe_iv_stats}()},
\code{\link{blr_woe_iv}()}
}
\concept{bivariate analysis procedures}
