% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{data_as_table}
\alias{data_as_table}
\title{Convert a list of data entries as returned by BLS API to a table}
\usage{
data_as_table(data)
}
\arguments{
\item{data}{a list of individual datum entries as returned the API}
}
\value{
tibble flattening \code{data} into rows for entries and columns for fields
}
\description{
Convert a list of data entries as returned by BLS API to a table
}
\details{
currently \code{data_as_table} is just an alias for \code{\link[dplyr:bind]{dplyr::bind_rows()}}
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
table <- data_as_table(series$data)
}
}
\seealso{
Other blsR-utils: 
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{tidy_periods}()}
}
\concept{blsR-utils}
