% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{merge_tables}
\alias{merge_tables}
\title{Turn a list of one or more series into a single table of time series data}
\usage{
merge_tables(tables, join_by = c("year", "period"))
}
\arguments{
\item{tables}{a named list of tables with matching periodicity. Mixing
data with different (monthly, quarterly, annual) periodicity is unsupported.
The list names will be used as column names in the output.}

\item{join_by}{an optional character vector of columns to use to join tables.}
}
\value{
tibble
}
\description{
\code{merge_tables()} turns a list of series as returned by
\code{\link[=data_as_table]{data_as_table()}} into a single tibble
}
\examples{
\dontrun{
series_ids <- list(uer.men ='LNS14000001', uer.women = 'LNS14000002')
uer_series <- get_n_series(series_ids, 'your-api-key-here' )
uer_tables <- lapply(uer_series, function(x) data_to_table(x$data))
big_table <- merge_tables(uer_tables)
}

}
\seealso{
Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tidy_tables}()},
\code{\link{tidy_periods}()}
}
\concept{blsR-utils}
