% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{tidy_periods}
\alias{tidy_periods}
\title{Clean the period information returned by BLS}
\usage{
tidy_periods(table)
}
\arguments{
\item{table}{a tibble of the \code{data} slot in a series}
}
\value{
a sorted tibble containing the period and the value
}
\description{
Clean the period information returned by BLS
}
\details{
\code{tidy_periods} will return a tibble where the period and periodName columns
have been deleted and replaced. Monthly periodicity data will have a new
column \code{month} and quarterly data will have a new column \code{quarter}. Rows will
be sorted from oldest to newest.
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
table <- data_as_table(series$data)
tidy_table <- tidy_periods(table)
}
}
\seealso{
Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{tidy_table_as_zoo}()}
}
\concept{blsR-utils}
