// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_bmlm_binary_y_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_bmlm_binary_y");
    reader.add_event(3, 3, "include", "chunks/data.stan");
    reader.add_event(3, 0, "start", "chunks/data.stan");
    reader.add_event(20, 17, "end", "chunks/data.stan");
    reader.add_event(20, 4, "restart", "model_bmlm_binary_y");
    reader.add_event(23, 7, "include", "chunks/transformed_data.stan");
    reader.add_event(23, 0, "start", "chunks/transformed_data.stan");
    reader.add_event(25, 2, "end", "chunks/transformed_data.stan");
    reader.add_event(25, 8, "restart", "model_bmlm_binary_y");
    reader.add_event(27, 10, "include", "chunks/parameters.stan");
    reader.add_event(27, 0, "start", "chunks/parameters.stan");
    reader.add_event(42, 15, "end", "chunks/parameters.stan");
    reader.add_event(42, 11, "restart", "model_bmlm_binary_y");
    reader.add_event(44, 13, "include", "chunks/transformed_parameters.stan");
    reader.add_event(44, 0, "start", "chunks/transformed_parameters.stan");
    reader.add_event(47, 3, "end", "chunks/transformed_parameters.stan");
    reader.add_event(47, 14, "restart", "model_bmlm_binary_y");
    reader.add_event(49, 16, "include", "chunks/model.stan");
    reader.add_event(49, 0, "start", "chunks/model.stan");
    reader.add_event(76, 27, "end", "chunks/model.stan");
    reader.add_event(76, 17, "restart", "model_bmlm_binary_y");
    reader.add_event(81, 22, "include", "chunks/generated_quantities.stan");
    reader.add_event(81, 0, "start", "chunks/generated_quantities.stan");
    reader.add_event(133, 52, "end", "chunks/generated_quantities.stan");
    reader.add_event(133, 23, "restart", "model_bmlm_binary_y");
    reader.add_event(136, 24, "end", "model_bmlm_binary_y");
    return reader;
}
#include <stan_meta_header.hpp>
class model_bmlm_binary_y
  : public stan::model::model_base_crtp<model_bmlm_binary_y> {
private:
        int N;
        int J;
        std::vector<int> id;
        vector_d X;
        vector_d M;
        double prior_dm;
        double prior_dy;
        double prior_a;
        double prior_b;
        double prior_cp;
        double prior_tau_dm;
        double prior_tau_dy;
        double prior_tau_a;
        double prior_tau_b;
        double prior_tau_cp;
        double prior_lkj_shape;
        std::vector<int> Y;
        int K;
public:
    model_bmlm_binary_y(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_bmlm_binary_y(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_bmlm_binary_y_namespace::model_bmlm_binary_y";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("id", "N", N);
            context__.validate_dims("data initialization", "id", "int", context__.to_vec(N));
            id = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("id");
            pos__ = 0;
            size_t id_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < id_k_0_max__; ++k_0__) {
                id[k_0__] = vals_i__[pos__++];
            }
            size_t id_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "id[i_0__]", id[i_0__], 1);
                check_less_or_equal(function__, "id[i_0__]", id[i_0__], J);
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("X", "N", N);
            context__.validate_dims("data initialization", "X", "vector_d", context__.to_vec(N));
            X = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                X(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("M", "N", N);
            context__.validate_dims("data initialization", "M", "vector_d", context__.to_vec(N));
            M = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("M");
            pos__ = 0;
            size_t M_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < M_j_1_max__; ++j_1__) {
                M(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "prior_dm", "double", context__.to_vec());
            prior_dm = double(0);
            vals_r__ = context__.vals_r("prior_dm");
            pos__ = 0;
            prior_dm = vals_r__[pos__++];
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "prior_dy", "double", context__.to_vec());
            prior_dy = double(0);
            vals_r__ = context__.vals_r("prior_dy");
            pos__ = 0;
            prior_dy = vals_r__[pos__++];
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "prior_a", "double", context__.to_vec());
            prior_a = double(0);
            vals_r__ = context__.vals_r("prior_a");
            pos__ = 0;
            prior_a = vals_r__[pos__++];
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "prior_b", "double", context__.to_vec());
            prior_b = double(0);
            vals_r__ = context__.vals_r("prior_b");
            pos__ = 0;
            prior_b = vals_r__[pos__++];
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "prior_cp", "double", context__.to_vec());
            prior_cp = double(0);
            vals_r__ = context__.vals_r("prior_cp");
            pos__ = 0;
            prior_cp = vals_r__[pos__++];
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "prior_tau_dm", "double", context__.to_vec());
            prior_tau_dm = double(0);
            vals_r__ = context__.vals_r("prior_tau_dm");
            pos__ = 0;
            prior_tau_dm = vals_r__[pos__++];
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "prior_tau_dy", "double", context__.to_vec());
            prior_tau_dy = double(0);
            vals_r__ = context__.vals_r("prior_tau_dy");
            pos__ = 0;
            prior_tau_dy = vals_r__[pos__++];
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "prior_tau_a", "double", context__.to_vec());
            prior_tau_a = double(0);
            vals_r__ = context__.vals_r("prior_tau_a");
            pos__ = 0;
            prior_tau_a = vals_r__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "prior_tau_b", "double", context__.to_vec());
            prior_tau_b = double(0);
            vals_r__ = context__.vals_r("prior_tau_b");
            pos__ = 0;
            prior_tau_b = vals_r__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "prior_tau_cp", "double", context__.to_vec());
            prior_tau_cp = double(0);
            vals_r__ = context__.vals_r("prior_tau_cp");
            pos__ = 0;
            prior_tau_cp = vals_r__[pos__++];
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "prior_lkj_shape", "double", context__.to_vec());
            prior_lkj_shape = double(0);
            vals_r__ = context__.vals_r("prior_lkj_shape");
            pos__ = 0;
            prior_lkj_shape = vals_r__[pos__++];
            current_statement_begin__ = 21;
            validate_non_negative_index("Y", "N", N);
            context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N));
            Y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("Y");
            pos__ = 0;
            size_t Y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < Y_k_0_max__; ++k_0__) {
                Y[k_0__] = vals_i__[pos__++];
            }
            size_t Y_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < Y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "Y[i_0__]", Y[i_0__], 0);
                check_less_or_equal(function__, "Y[i_0__]", Y[i_0__], 1);
            }
            // initialize transformed data variables
            current_statement_begin__ = 24;
            K = int(0);
            stan::math::fill(K, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 25;
            stan::math::assign(K, 5);
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            num_params_r__ += 1;
            current_statement_begin__ = 33;
            num_params_r__ += 1;
            current_statement_begin__ = 34;
            num_params_r__ += 1;
            current_statement_begin__ = 35;
            num_params_r__ += 1;
            current_statement_begin__ = 38;
            validate_non_negative_index("L_Omega", "K", K);
            validate_non_negative_index("L_Omega", "K", K);
            num_params_r__ += ((K * (K - 1)) / 2);
            current_statement_begin__ = 39;
            validate_non_negative_index("Tau", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 42;
            validate_non_negative_index("z_U", "K", K);
            validate_non_negative_index("z_U", "J", J);
            num_params_r__ += (K * J);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_bmlm_binary_y() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 29;
        if (!(context__.contains_r("dy")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable dy missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("dy");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "dy", "double", context__.to_vec());
        double dy(0);
        dy = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dy);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable dy: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("cp")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable cp missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("cp");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "cp", "double", context__.to_vec());
        double cp(0);
        cp = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(cp);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable cp: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "b", "double", context__.to_vec());
        double b(0);
        b = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 33;
        if (!(context__.contains_r("dm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable dm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("dm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "dm", "double", context__.to_vec());
        double dm(0);
        dm = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable dm: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 34;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "a", "double", context__.to_vec());
        double a(0);
        a = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 35;
        if (!(context__.contains_r("sigma_m")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_m missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_m");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_m", "double", context__.to_vec());
        double sigma_m(0);
        sigma_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_m);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_m: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 38;
        if (!(context__.contains_r("L_Omega")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable L_Omega missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        validate_non_negative_index("L_Omega", "K", K);
        validate_non_negative_index("L_Omega", "K", K);
        context__.validate_dims("parameter initialization", "L_Omega", "matrix_d", context__.to_vec(K,K));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega(K, K);
        size_t L_Omega_j_2_max__ = K;
        size_t L_Omega_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                L_Omega(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(L_Omega);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 39;
        if (!(context__.contains_r("Tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Tau");
        pos__ = 0U;
        validate_non_negative_index("Tau", "K", K);
        context__.validate_dims("parameter initialization", "Tau", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> Tau(K);
        size_t Tau_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < Tau_j_1_max__; ++j_1__) {
            Tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, Tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 42;
        if (!(context__.contains_r("z_U")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_U missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_U");
        pos__ = 0U;
        validate_non_negative_index("z_U", "K", K);
        validate_non_negative_index("z_U", "J", J);
        context__.validate_dims("parameter initialization", "z_U", "matrix_d", context__.to_vec(K,J));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z_U(K, J);
        size_t z_U_j_2_max__ = J;
        size_t z_U_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < z_U_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_U_j_1_max__; ++j_1__) {
                z_U(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(z_U);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_U: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 29;
            local_scalar_t__ dy;
            (void) dy;  // dummy to suppress unused var warning
            if (jacobian__)
                dy = in__.scalar_constrain(lp__);
            else
                dy = in__.scalar_constrain();
            current_statement_begin__ = 30;
            local_scalar_t__ cp;
            (void) cp;  // dummy to suppress unused var warning
            if (jacobian__)
                cp = in__.scalar_constrain(lp__);
            else
                cp = in__.scalar_constrain();
            current_statement_begin__ = 31;
            local_scalar_t__ b;
            (void) b;  // dummy to suppress unused var warning
            if (jacobian__)
                b = in__.scalar_constrain(lp__);
            else
                b = in__.scalar_constrain();
            current_statement_begin__ = 33;
            local_scalar_t__ dm;
            (void) dm;  // dummy to suppress unused var warning
            if (jacobian__)
                dm = in__.scalar_constrain(lp__);
            else
                dm = in__.scalar_constrain();
            current_statement_begin__ = 34;
            local_scalar_t__ a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.scalar_constrain(lp__);
            else
                a = in__.scalar_constrain();
            current_statement_begin__ = 35;
            local_scalar_t__ sigma_m;
            (void) sigma_m;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_m = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_m = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 38;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L_Omega;
            (void) L_Omega;  // dummy to suppress unused var warning
            if (jacobian__)
                L_Omega = in__.cholesky_factor_corr_constrain(K, lp__);
            else
                L_Omega = in__.cholesky_factor_corr_constrain(K);
            current_statement_begin__ = 39;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Tau;
            (void) Tau;  // dummy to suppress unused var warning
            if (jacobian__)
                Tau = in__.vector_lb_constrain(0, K, lp__);
            else
                Tau = in__.vector_lb_constrain(0, K);
            current_statement_begin__ = 42;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> z_U;
            (void) z_U;  // dummy to suppress unused var warning
            if (jacobian__)
                z_U = in__.matrix_constrain(K, J, lp__);
            else
                z_U = in__.matrix_constrain(K, J);
            // transformed parameters
            current_statement_begin__ = 46;
            validate_non_negative_index("U", "J", J);
            validate_non_negative_index("U", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> U(J, K);
            stan::math::initialize(U, DUMMY_VAR__);
            stan::math::fill(U, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 47;
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau, L_Omega), z_U)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 46;
            size_t U_j_1_max__ = J;
            size_t U_j_2_max__ = K;
            for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < U_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(U(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: U" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable U: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 51;
            validate_non_negative_index("mu_y", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_y(N);
            stan::math::initialize(mu_y, DUMMY_VAR__);
            stan::math::fill(mu_y, DUMMY_VAR__);
            current_statement_begin__ = 52;
            validate_non_negative_index("mu_m", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_m(N);
            stan::math::initialize(mu_m, DUMMY_VAR__);
            stan::math::fill(mu_m, DUMMY_VAR__);
            current_statement_begin__ = 54;
            lp_accum__.add(normal_log<propto__>(dy, 0, prior_dy));
            current_statement_begin__ = 55;
            lp_accum__.add(normal_log<propto__>(dm, 0, prior_dm));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(a, 0, prior_a));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log<propto__>(b, 0, prior_b));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log<propto__>(cp, 0, prior_cp));
            current_statement_begin__ = 60;
            lp_accum__.add(cauchy_log<propto__>(get_base1(Tau, 1, "Tau", 1), 0, prior_tau_cp));
            current_statement_begin__ = 61;
            lp_accum__.add(cauchy_log<propto__>(get_base1(Tau, 2, "Tau", 1), 0, prior_tau_b));
            current_statement_begin__ = 62;
            lp_accum__.add(cauchy_log<propto__>(get_base1(Tau, 3, "Tau", 1), 0, prior_tau_a));
            current_statement_begin__ = 63;
            lp_accum__.add(cauchy_log<propto__>(get_base1(Tau, 4, "Tau", 1), 0, prior_tau_dy));
            current_statement_begin__ = 64;
            lp_accum__.add(cauchy_log<propto__>(get_base1(Tau, 5, "Tau", 1), 0, prior_tau_dm));
            current_statement_begin__ = 65;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_Omega, prior_lkj_shape));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(to_vector(z_U), 0, 1));
            current_statement_begin__ = 70;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 71;
                stan::model::assign(mu_y, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            ((((cp + get_base1(U, get_base1(id, n, "id", 1), 1, "U", 1)) * get_base1(X, n, "X", 1)) + ((b + get_base1(U, get_base1(id, n, "id", 1), 2, "U", 1)) * get_base1(M, n, "M", 1))) + (dy + get_base1(U, get_base1(id, n, "id", 1), 4, "U", 1))), 
                            "assigning variable mu_y");
                current_statement_begin__ = 74;
                stan::model::assign(mu_m, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (((a + get_base1(U, get_base1(id, n, "id", 1), 3, "U", 1)) * get_base1(X, n, "X", 1)) + (dm + get_base1(U, get_base1(id, n, "id", 1), 5, "U", 1))), 
                            "assigning variable mu_m");
            }
            current_statement_begin__ = 78;
            lp_accum__.add(bernoulli_logit_log<propto__>(Y, mu_y));
            current_statement_begin__ = 79;
            lp_accum__.add(normal_log<propto__>(M, mu_m, sigma_m));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("dy");
        names__.push_back("cp");
        names__.push_back("b");
        names__.push_back("dm");
        names__.push_back("a");
        names__.push_back("sigma_m");
        names__.push_back("L_Omega");
        names__.push_back("Tau");
        names__.push_back("z_U");
        names__.push_back("U");
        names__.push_back("Omega");
        names__.push_back("Sigma");
        names__.push_back("covab");
        names__.push_back("corrab");
        names__.push_back("me");
        names__.push_back("c");
        names__.push_back("pme");
        names__.push_back("u_a");
        names__.push_back("u_b");
        names__.push_back("u_cp");
        names__.push_back("u_dy");
        names__.push_back("u_dm");
        names__.push_back("u_c");
        names__.push_back("u_me");
        names__.push_back("u_pme");
        names__.push_back("tau_cp");
        names__.push_back("tau_b");
        names__.push_back("tau_a");
        names__.push_back("tau_dy");
        names__.push_back("tau_dm");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_bmlm_binary_y_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double dy = in__.scalar_constrain();
        vars__.push_back(dy);
        double cp = in__.scalar_constrain();
        vars__.push_back(cp);
        double b = in__.scalar_constrain();
        vars__.push_back(b);
        double dm = in__.scalar_constrain();
        vars__.push_back(dm);
        double a = in__.scalar_constrain();
        vars__.push_back(a);
        double sigma_m = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_m);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega = in__.cholesky_factor_corr_constrain(K);
        size_t L_Omega_j_2_max__ = K;
        size_t L_Omega_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                vars__.push_back(L_Omega(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> Tau = in__.vector_lb_constrain(0, K);
        size_t Tau_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < Tau_j_1_max__; ++j_1__) {
            vars__.push_back(Tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z_U = in__.matrix_constrain(K, J);
        size_t z_U_j_2_max__ = J;
        size_t z_U_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < z_U_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_U_j_1_max__; ++j_1__) {
                vars__.push_back(z_U(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 46;
            validate_non_negative_index("U", "J", J);
            validate_non_negative_index("U", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> U(J, K);
            stan::math::initialize(U, DUMMY_VAR__);
            stan::math::fill(U, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 47;
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau, L_Omega), z_U)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t U_j_2_max__ = K;
                size_t U_j_1_max__ = J;
                for (size_t j_2__ = 0; j_2__ < U_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
                        vars__.push_back(U(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 82;
            validate_non_negative_index("Omega", "K", K);
            validate_non_negative_index("Omega", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega(K, K);
            stan::math::initialize(Omega, DUMMY_VAR__);
            stan::math::fill(Omega, DUMMY_VAR__);
            current_statement_begin__ = 83;
            validate_non_negative_index("Sigma", "K", K);
            validate_non_negative_index("Sigma", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma(K, K);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 86;
            double covab;
            (void) covab;  // dummy to suppress unused var warning
            stan::math::initialize(covab, DUMMY_VAR__);
            stan::math::fill(covab, DUMMY_VAR__);
            current_statement_begin__ = 87;
            double corrab;
            (void) corrab;  // dummy to suppress unused var warning
            stan::math::initialize(corrab, DUMMY_VAR__);
            stan::math::fill(corrab, DUMMY_VAR__);
            current_statement_begin__ = 88;
            double me;
            (void) me;  // dummy to suppress unused var warning
            stan::math::initialize(me, DUMMY_VAR__);
            stan::math::fill(me, DUMMY_VAR__);
            current_statement_begin__ = 89;
            double c;
            (void) c;  // dummy to suppress unused var warning
            stan::math::initialize(c, DUMMY_VAR__);
            stan::math::fill(c, DUMMY_VAR__);
            current_statement_begin__ = 90;
            double pme;
            (void) pme;  // dummy to suppress unused var warning
            stan::math::initialize(pme, DUMMY_VAR__);
            stan::math::fill(pme, DUMMY_VAR__);
            current_statement_begin__ = 93;
            validate_non_negative_index("u_a", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_a(J);
            stan::math::initialize(u_a, DUMMY_VAR__);
            stan::math::fill(u_a, DUMMY_VAR__);
            current_statement_begin__ = 94;
            validate_non_negative_index("u_b", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_b(J);
            stan::math::initialize(u_b, DUMMY_VAR__);
            stan::math::fill(u_b, DUMMY_VAR__);
            current_statement_begin__ = 95;
            validate_non_negative_index("u_cp", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_cp(J);
            stan::math::initialize(u_cp, DUMMY_VAR__);
            stan::math::fill(u_cp, DUMMY_VAR__);
            current_statement_begin__ = 96;
            validate_non_negative_index("u_dy", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_dy(J);
            stan::math::initialize(u_dy, DUMMY_VAR__);
            stan::math::fill(u_dy, DUMMY_VAR__);
            current_statement_begin__ = 97;
            validate_non_negative_index("u_dm", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_dm(J);
            stan::math::initialize(u_dm, DUMMY_VAR__);
            stan::math::fill(u_dm, DUMMY_VAR__);
            current_statement_begin__ = 98;
            validate_non_negative_index("u_c", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_c(J);
            stan::math::initialize(u_c, DUMMY_VAR__);
            stan::math::fill(u_c, DUMMY_VAR__);
            current_statement_begin__ = 99;
            validate_non_negative_index("u_me", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_me(J);
            stan::math::initialize(u_me, DUMMY_VAR__);
            stan::math::fill(u_me, DUMMY_VAR__);
            current_statement_begin__ = 100;
            validate_non_negative_index("u_pme", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u_pme(J);
            stan::math::initialize(u_pme, DUMMY_VAR__);
            stan::math::fill(u_pme, DUMMY_VAR__);
            current_statement_begin__ = 103;
            double tau_cp;
            (void) tau_cp;  // dummy to suppress unused var warning
            stan::math::initialize(tau_cp, DUMMY_VAR__);
            stan::math::fill(tau_cp, DUMMY_VAR__);
            current_statement_begin__ = 104;
            double tau_b;
            (void) tau_b;  // dummy to suppress unused var warning
            stan::math::initialize(tau_b, DUMMY_VAR__);
            stan::math::fill(tau_b, DUMMY_VAR__);
            current_statement_begin__ = 105;
            double tau_a;
            (void) tau_a;  // dummy to suppress unused var warning
            stan::math::initialize(tau_a, DUMMY_VAR__);
            stan::math::fill(tau_a, DUMMY_VAR__);
            current_statement_begin__ = 106;
            double tau_dy;
            (void) tau_dy;  // dummy to suppress unused var warning
            stan::math::initialize(tau_dy, DUMMY_VAR__);
            stan::math::fill(tau_dy, DUMMY_VAR__);
            current_statement_begin__ = 107;
            double tau_dm;
            (void) tau_dm;  // dummy to suppress unused var warning
            stan::math::initialize(tau_dm, DUMMY_VAR__);
            stan::math::fill(tau_dm, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 109;
            stan::math::assign(tau_cp, get_base1(Tau, 1, "Tau", 1));
            current_statement_begin__ = 110;
            stan::math::assign(tau_b, get_base1(Tau, 2, "Tau", 1));
            current_statement_begin__ = 111;
            stan::math::assign(tau_a, get_base1(Tau, 3, "Tau", 1));
            current_statement_begin__ = 112;
            stan::math::assign(tau_dy, get_base1(Tau, 4, "Tau", 1));
            current_statement_begin__ = 113;
            stan::math::assign(tau_dm, get_base1(Tau, 5, "Tau", 1));
            current_statement_begin__ = 115;
            stan::math::assign(Omega, multiply(L_Omega, transpose(L_Omega)));
            current_statement_begin__ = 116;
            stan::math::assign(Sigma, quad_form_diag(Omega, Tau));
            current_statement_begin__ = 118;
            stan::math::assign(covab, get_base1(Sigma, 3, 2, "Sigma", 1));
            current_statement_begin__ = 119;
            stan::math::assign(corrab, get_base1(Omega, 3, 2, "Omega", 1));
            current_statement_begin__ = 120;
            stan::math::assign(me, ((a * b) + covab));
            current_statement_begin__ = 121;
            stan::math::assign(c, (cp + me));
            current_statement_begin__ = 122;
            stan::math::assign(pme, (me / c));
            current_statement_begin__ = 124;
            for (int j = 1; j <= J; ++j) {
                current_statement_begin__ = 125;
                stan::model::assign(u_a, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (a + get_base1(U, j, 3, "U", 1)), 
                            "assigning variable u_a");
                current_statement_begin__ = 126;
                stan::model::assign(u_b, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (b + get_base1(U, j, 2, "U", 1)), 
                            "assigning variable u_b");
                current_statement_begin__ = 127;
                stan::model::assign(u_me, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            ((a + get_base1(U, j, 3, "U", 1)) * (b + get_base1(U, j, 2, "U", 1))), 
                            "assigning variable u_me");
                current_statement_begin__ = 128;
                stan::model::assign(u_cp, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (cp + get_base1(U, j, 1, "U", 1)), 
                            "assigning variable u_cp");
                current_statement_begin__ = 129;
                stan::model::assign(u_dy, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (dy + get_base1(U, j, 4, "U", 1)), 
                            "assigning variable u_dy");
                current_statement_begin__ = 130;
                stan::model::assign(u_dm, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (dm + get_base1(U, j, 5, "U", 1)), 
                            "assigning variable u_dm");
                current_statement_begin__ = 131;
                stan::model::assign(u_c, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (get_base1(u_cp, j, "u_cp", 1) + get_base1(u_me, j, "u_me", 1)), 
                            "assigning variable u_c");
                current_statement_begin__ = 132;
                stan::model::assign(u_pme, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            (get_base1(u_me, j, "u_me", 1) / get_base1(u_c, j, "u_c", 1)), 
                            "assigning variable u_pme");
            }
            // validate, write generated quantities
            current_statement_begin__ = 82;
            size_t Omega_j_2_max__ = K;
            size_t Omega_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                    vars__.push_back(Omega(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 83;
            size_t Sigma_j_2_max__ = K;
            size_t Sigma_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                    vars__.push_back(Sigma(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 86;
            vars__.push_back(covab);
            current_statement_begin__ = 87;
            vars__.push_back(corrab);
            current_statement_begin__ = 88;
            vars__.push_back(me);
            current_statement_begin__ = 89;
            vars__.push_back(c);
            current_statement_begin__ = 90;
            vars__.push_back(pme);
            current_statement_begin__ = 93;
            size_t u_a_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_a_j_1_max__; ++j_1__) {
                vars__.push_back(u_a(j_1__));
            }
            current_statement_begin__ = 94;
            size_t u_b_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_b_j_1_max__; ++j_1__) {
                vars__.push_back(u_b(j_1__));
            }
            current_statement_begin__ = 95;
            size_t u_cp_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_cp_j_1_max__; ++j_1__) {
                vars__.push_back(u_cp(j_1__));
            }
            current_statement_begin__ = 96;
            size_t u_dy_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_dy_j_1_max__; ++j_1__) {
                vars__.push_back(u_dy(j_1__));
            }
            current_statement_begin__ = 97;
            size_t u_dm_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_dm_j_1_max__; ++j_1__) {
                vars__.push_back(u_dm(j_1__));
            }
            current_statement_begin__ = 98;
            size_t u_c_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_c_j_1_max__; ++j_1__) {
                vars__.push_back(u_c(j_1__));
            }
            current_statement_begin__ = 99;
            size_t u_me_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_me_j_1_max__; ++j_1__) {
                vars__.push_back(u_me(j_1__));
            }
            current_statement_begin__ = 100;
            size_t u_pme_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < u_pme_j_1_max__; ++j_1__) {
                vars__.push_back(u_pme(j_1__));
            }
            current_statement_begin__ = 103;
            vars__.push_back(tau_cp);
            current_statement_begin__ = 104;
            vars__.push_back(tau_b);
            current_statement_begin__ = 105;
            vars__.push_back(tau_a);
            current_statement_begin__ = 106;
            vars__.push_back(tau_dy);
            current_statement_begin__ = 107;
            vars__.push_back(tau_dm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_bmlm_binary_y";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        size_t L_Omega_j_2_max__ = K;
        size_t L_Omega_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Tau_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < Tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_U_j_2_max__ = J;
        size_t z_U_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < z_U_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_U_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t U_j_2_max__ = K;
            size_t U_j_1_max__ = J;
            for (size_t j_2__ = 0; j_2__ < U_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "U" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t Omega_j_2_max__ = K;
        size_t Omega_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Sigma_j_2_max__ = K;
        size_t Sigma_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        size_t u_a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_b_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_cp_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_cp_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_dy_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_dy_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_dm_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_dm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_c_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_c_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_me_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_me_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_pme_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_pme_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        size_t L_Omega_j_1_max__ = ((K * (K - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_Omega" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Tau_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < Tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_U_j_2_max__ = J;
        size_t z_U_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < z_U_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_U_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t U_j_2_max__ = K;
            size_t U_j_1_max__ = J;
            for (size_t j_2__ = 0; j_2__ < U_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "U" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t Omega_j_2_max__ = K;
        size_t Omega_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Sigma_j_2_max__ = K;
        size_t Sigma_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        size_t u_a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_b_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_cp_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_cp_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_dy_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_dy_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_dm_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_dm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_c_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_c_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_me_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_me_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_pme_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < u_pme_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_bmlm_binary_y_namespace::model_bmlm_binary_y stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
