% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionlists.R
\name{bnclustNetworks}
\alias{bnclustNetworks}
\title{Deriving consensus networks based on posterior probabilities of mixture model}
\usage{
bnclustNetworks(
  bnres,
  bnnames,
  sump = 1.2,
  minp = 0.5,
  minkp = 0.9,
  maxkp = NULL
)
}
\arguments{
\item{bnres}{an object of class 'bnclustOmics'; see \link{bnclustOmics}}

\item{bnnames}{an object of class 'bnInfo'; see \link{bnInfo}}

\item{sump}{threshold for the sum of posterior probabilities in all discovered networks}

\item{minp}{threshold for the minimum posterior probability in at least one network, when the sum of posterioirs is bigger than sump}

\item{minkp}{threshold for the minimum posterior probability in at least one network, when the sum of posterioirs is less than sump}

\item{maxkp}{(optional) threshold for the maximum posterior probability in at least one network; used to esclude cluster specific edges from the edges with high sum of posterioirs (>sump)}
}
\value{
returns a list of adjacency matrices, one for each cluster representing consensus models
}
\description{
This function derives consensus models of networks representing all clusters based on several
threshold for posterior probabilities of individual edges.
}
\examples{
bnnames<-bnInfo(simdata,c("b","c"),c("M","T"))
intlist<-bnclustNetworks(bnres3,bnnames)
}
