% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBNomics.R
\name{plotNode}
\alias{plotNode}
\title{Plotting all connections of one node}
\usage{
plotNode(localint, node, p = 0.3, rmult = 7, dbcheck = TRUE, cex = 0.5)
}
\arguments{
\item{localint}{an annotated list of interactions obtained by the function \link{annotateEdges}}

\item{node}{center node name}

\item{p}{defines a threshold for the posterior probability; edges whose posterior is higher than the threshold will be plotted}

\item{rmult}{defines the raduis of the circle}

\item{dbcheck}{logical, defines if interactions absent in the database are denoted with a dashed line}

\item{cex}{regulates font size}
}
\value{
plots a graph consisting of a specified node and its neighbours in the networks representing clusters identified by 'bnclustOmics'
}
\description{
This function plots all connections (incoming and outgoing) of a specific node in one network or in all network in the discovered model.
}
\examples{
bnnames<-bnInfo(simdata,c("b","c"),c("M","T"))
allInteractions<-annotateEdges(bnres3,bnnames,sump=1.2,minp=0.5,minkp=0.9,dblist=simint)
plotNode(allInteractions,"T43",p=0.5)
plotNode(allInteractions,"T43",p=0.5,dbcheck=FALSE)
}
\author{
Polina Suter
}
