% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estuary.R
\docType{data}
\name{estuary}
\alias{estuary}
\title{estuary Bayesian Network}
\format{
A discrete Bayesian network to calculate an Estuary Trophic Index (ETI) score ranging between 0 (no symptoms of eutrophication) to 1 (grossly eutrophic) for estuaries in Aotearoa New Zealand. The probabilities were given within the referenced paper. The vertices are:
\describe{
\item{EstuaryType}{(Coastal lake, Tidal lagoon, Tidal river);}
\item{Intertidal}{(0 to 5, 5 to 40, 40 to 100);}
\item{Flushing}{(0 to 3, 3 to 6, 6 to 10, More than 10);}
\item{Salinity}{(0 to 5, 5 to 30, More than 30);}
\item{PotentialTNConcentration}{(0 to 50, 50 to 100, 100 to 150, 150 to 200, 200 to 300, 300 to 400, 400 to 500, 500 to 600, 600 to 700, 700 to 1000, 1000 to 2000);}
\item{Seasonality}{(Less than 0.5, 0.5 to 0.65, More than 0.65);}
\item{WaterColStratification}{(Yes, No);}
\item{ClosureDuration}{(Open, Short close, Long close);}
\item{SedimentLoad}{(0 to 1, 1 to 5, 5 to 10, 10 to 20, 20 to 50, 50 to 100, More than 100);}
\item{SedTrappingEfficiency}{(0 to 0.1, 0.1 to 0.5, 0.5 to 0.85, 0.85 to 0.95, 0.95 to 1);}
\item{SedDeposition}{(0 to 0.1, 0.1 to 0.5, 0.5 to 1, 1 to 2, 2 to 5, 5 to 10, More than 10);}
\item{SedMud}{(0 to 12, 12 to 25, 25 to 34, 34 to 100);}
\item{Macroalgae}{(0.8 to 1, 0.6 to 0.8, 0.4 to 0.6, 0 to 0.4);}
\item{Phytoplankton}{(0 to 5, 5 to 10, 10 to 15, 15 to 25, 25 to 60, 60 to 100);}
\item{MacroalgaeStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{PhytoplanktonStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{ETIPrimaryScore}{(0 to 0.1, 0.1 to 0.2, 0.2 to 0.3, 0.3 to 0.4, 0.4 to 0.5, 0.5 to 0.6, 0.6 to 0.7, 0.7 to 0.8, 0.8 to 0.9, 0.9 to 1.0);}
\item{Oxygen}{(7 to 8, 6 to 7, 5 to 6, 4 to 5);}
\item{OxygenStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{SedToc}{(0 to 0.5, 0.5 to 1.2, 1.2 to 2, 2 to 10);}
\item{SedARPD}{(More than 4, 2.5 to 4, 1 to 2.5, Less than 1);}
\item{SedARPDStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{SedTocStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{SeagrassDecline}{(Extreme, Severe, Moderate, Minor);}
\item{SeagrassStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{Macrobenthos}{(0 to 1.2, 1.2 to 3.3, 3.3 to 4.3, 4.3 to 7);}
\item{MacrobenthosStandardised}{(0 to 0.25, 0.25 to 0.5, 0.5 to 0.75, 0.75 to 1);}
\item{ETISecondaryScore}{(0 to 0.1, 0.1 to 0.2, 0.2 to 0.3, 0.3 to 0.4, 0.4 to 0.5, 0.5 to 0.6, 0.6 to 0.7, 0.7 to 0.8, 0.8 to 0.9, 0.9 to 1.0);}
\item{ETIScore}{(0 to 0.1, 0.1 to 0.2, 0.2 to 0.3, 0.3 to 0.4, 0.4 to 0.5, 0.5 to 0.6, 0.6 to 0.7, 0.7 to 0.8, 0.8 to 0.9, 0.9 to 1.0);}
\item{ETIBand}{(A, B, C, D);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Predicting and scoring estuary ecological health using a Bayesian belief network.
}
\references{
Zeldis, J. R., & Plew, D. R. (2022). Predicting and scoring estuary ecological health using a Bayesian belief network. Frontiers in Marine Science, 9, 898992.
}
