#' BOPfailure Bayesian Networks
#'
#' Providing a comprehensive approach to oil well blowout risk assessment.
#'
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network for risk assessment of oil well blowout (Fig. 3 of the referenced paper). Probabilities were given within the referenced paper. The vertices are:
#' \describe{
#'   \item{Kick}{(F, S);}
#'   \item{X1}{Efficient hydrocarbon formation (F, S);}
#'   \item{X2}{Negative diffraction pressure (F, S);}
#'   \item{X3}{Sufficient permeability (F, S);}
#'   \item{X4}{Low hydrostatic pressure (F, S);}
#'   \item{X5}{Low and lost Annular Pressure Loss (F, S);}
#'   \item{X6}{Surface line failure (F, S);}
#'   \item{X7}{Power failure (F, S);}
#'   \item{X8}{Pump failure (F, S);}
#'   \item{X9}{Operator failure to notice adjustment (F, S);}
#'   \item{X10}{Pump control failure (F, S);}
#'   \item{X11}{Leakage from the pump’s fluid side (F, S);}
#'   \item{X12}{Blowing (F, S);}
#'   \item{X13}{Density reduction (F, S);}
#'   \item{X14}{Volume reduction (F, S);}
#'   \item{X15}{Inadequate holes fill up (F, S);}
#'   \item{X16}{Mud loss (F, S);}
#'   \item{X17}{Gas-cut mud (F, S);}
#'   \item{X18}{Abnormal pressurize (F, S);}
#'   \item{X19}{Swabbing while tripping (F, S);}
#'   \item{X20}{Mud weight reduction (F, S);}
#'   \item{X21}{Failure in Mud treatment equipment (F, S);}
#'   \item{X22}{Formation (F, S);}
#'   \item{X23}{Increasing mud weight (F, S);}
#'   \item{X24}{Annular losses (F, S);}
#'   \item{X25}{Bad cementing (F, S);}
#'   \item{X26}{Casing failure (F, S);}
#'   \item{X27}{Surging-piston effect (F, S);}
#'   \item{X28}{Failure in centrifuge (F, S);}
#'   \item{X29}{Failure in degasser (F, S);}
#'   \item{X30}{Mud cleaner equipment in adjustment (F, S);}
#'   \item{X31}{Power failure (F, S);}
#'   \item{X32}{Agitator(mixer) failure (F, S);}
#'   \item{X33}{Settlement of mud-weight substance (F, S);}
#'   \item{X34}{Pulling the pipe too fast (F, S);}
#'   \item{X35}{Using Mud with high viscosity and high gel strength (F, S);}
#'   \item{X36}{Having balled up a bit (F, S);}
#'   \item{X37}{Having thick wall cake (F, S);}
#'   \item{X38}{Having a small clearance between the string and the hole (F, S);}
#'   \item{X39}{Having and plugged drill string (F, S);}
#'   \item{X40}{Directing the pipes at the speed inside the well (F, S);}
#'   \item{X41}{Using mud of high viscosity & and high gel strength (F, S);}
#'   \item{X42}{Having balled up (F, S);}
#'   \item{X43}{Having Thick wall cake (F, S);}
#'   \item{X44}{Having a small clearance between the string and the hole (F, S);}
#'   \item{X45}{Using the float valve /nonreturn safety valve (F, S);}
#'    }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords ReverseTree
#' @importClassesFrom bnlearn bn.fit
#' @references Satiarvand, M., Orak, N., Varshosaz, K., Hassan, E. M., & Cheraghi, M. (2023). Providing a comprehensive approach to oil well blowout risk assessment. Plos One, 18(12), e0296086.
"BOPfailure2"
