% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.network.R
\name{summary.contrast.network.result}
\alias{summary.contrast.network.result}
\title{Summarize result run by \code{\link{contrast.network.run}}}
\usage{
\method{summary}{contrast.network.result}(object, ...)
}
\arguments{
\item{object}{Result object created by \code{\link{contrast.network.run}} function}

\item{...}{Additional arguments affecting the summary produced}
}
\value{
Returns summary of the contrast network model result
}
\description{
This function uses summary function in coda package to summarize mcmc.list object. Monte carlo error (Time-series SE) is also obtained using the coda package and is printed in the summary as a default.
}
\examples{
network <- with(parkinsons_contrast, {
 contrast.network.data(Outcomes, Treat, SE, na, V)
})
\donttest{
result <- contrast.network.run(network)
summary(result)
}
}
