% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Sensitivity function}
\usage{
sensitivity(
  bnfit,
  interest_node,
  interest_node_value,
  evidence_nodes = NULL,
  evidence_states = NULL,
  node,
  value_node,
  value_parents,
  new_value,
  covariation = "proportional"
)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}

\item{interest_node}{character string. Node of the probability query of interest.}

\item{interest_node_value}{character string. Level of \code{interest_node}.}

\item{evidence_nodes}{character string. Evidence nodes. If \code{NULL} no evidence is considered. Set by default to \code{NULL}.}

\item{evidence_states}{character string. Levels of \code{evidence_nodes}. If \code{NULL} no evidence is considered. If \code{evidence_nodes="NULL"}, \code{evidence_states} should be set to \code{NULL}. Set by default to \code{NULL}.}

\item{node}{character string. Node of which the conditional probability distribution is being changed.}

\item{value_node}{character string. Level of \code{node}.}

\item{value_parents}{character string. Levels of \code{node}'s parents. The levels should be defined according to the order of the parents in \code{bnfit[[node]][["parents"]]}. If \code{node} has no parents, then should be set to \code{NULL}.}

\item{new_value}{numeric vector with elements between 0 and 1. Values to which the parameter should be updated. It can take a specific value or more than one. For more than one value, these should be defined through a vector with an increasing order of the elements. \code{new_value} can also take as value the character string \code{all}: in this case a sequence of possible parameter changes ranging from 0.05 to 0.95 is considered.}

\item{covariation}{character string. Co-variation scheme to be used for the updated Bayesian network. Can take values \code{uniform}, \code{proportional}, \code{orderp}, \code{all}. If equal to \code{all}, uniform, proportional and order-preserving co-variation schemes are considered. Set by default to \code{proportional}.}
}
\value{
A dataframe with the varied parameter values and the output probabilities for the co-variation schemes selected. If \code{plot = TRUE} the function also returns a plot of the sensitivity function.
}
\description{
\code{sensitivity} returns the sensitivity function for a probabilistic query of interest with respect to a parameter change defined by the user.
}
\details{
The Bayesian network on which parameter variation is being conducted should be expressed as a bn.fit object.
The name of the node to be varied, its level and its parent's level should be specified.
The parameter variation specified by the function is:

 P ( \code{node} = \code{value_node} | parents = \code{value_parents} ) = \code{new_value}

and the probabilistic query of interest is:

 P ( \code{interest_node} = \code{interest_node_value} | \code{evidence_nodes} = \code{evidence_states} )
}
\references{
Coupé, V. M., & Van Der Gaag, L. C. (2002). Properties of sensitivity analysis of Bayesian belief networks. Annals of Mathematics and Artificial Intelligence, 36(4), 323-356.

Leonelli, M., Goergen, C., & Smith, J. Q. (2017). Sensitivity analysis in multilinear probabilistic models. Information Sciences, 411, 84-97.
}
\seealso{
\code{\link{covariation}}, \code{\link{sensquery}}
}
