% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeno.R
\name{rgeno}
\alias{rgeno}
\title{Draw genotypes from the admixture model}
\usage{
rgeno(P, Q = NULL, lowMem = FALSE)
}
\arguments{
\item{P}{The \eqn{m \times n}{m-by-n} IAF matrix (if \eqn{Q} is missing) or the \eqn{m \times k}{m-by-k} intermediate subpopulation allele frequency matrix (if \eqn{Q} is present)}

\item{Q}{The optional \eqn{n \times k}{n-by-k} admixture proportion matrix}

\item{lowMem}{If \code{TRUE}, the low-memory algorithm is used (Q must be present)}
}
\value{
The \eqn{m \times n}{m-by-n} genotype matrix
}
\description{
Given the Individual-specific Allele Frequency (IAF) \eqn{\pi_{ij}} for locus \eqn{i} and individual \eqn{j}, genotypes are drawn binomially:
\deqn{x_{ij}|\pi_{ij} \sim \mbox{Binomial}(2, \pi_{ij}).}
Below \eqn{m} is the number of loci, \eqn{n} the number of individuals, and \eqn{k} the number of intermediate subpopulations.
If an admixture proportion matrix \eqn{Q} is provided as the second argument, the first argument \eqn{P} is treated as the intermediate subpopulation allele frequency matrix and the IAF matrix is given by
\deqn{P Q^T.}{P \%*\% t(Q).}
If \eqn{Q} is missing, then \eqn{P} is treated as the IAF matrix.
}
\details{
To reduce memory, set \code{lowMem=TRUE} to draw genotypes one locus at the time from \eqn{P} and \eqn{Q} (both must be present).
This low-memory algorithm prevents the construction of the entire IAF matrix, but is considerably slower than the standard algorithm.
}
\examples{
# dimensions
m <- 10 # number of loci
n <- 5 # number of individuals
k <- 2 # number of intermediate subpops

# define population structure
F <- c(0.1, 0.3) # FST values for k=2 subpops
sigma <- 1 # dispersion parameter of intermediate subpops
Q <- q1d(n, k, sigma) # non-trivial admixture proportions

# draw alelle frequencies
pAnc <- rpanc(m) # random vector of ancestral allele frequencies
B <- rpint(pAnc, F) # matrix of intermediate subpop allele freqs
P <- rpiaf(B,Q) # matrix of individual-specific allele frequencies

# draw genotypes from intermediate subpops (one individual each)
Xb <- rgeno(B)
# and genotypes for admixed individuals
Xp <- rgeno(P)

}
