% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_admix.R
\name{fst_admix}
\alias{fst_admix}
\title{Calculate FST for the admixed individuals}
\usage{
fst_admix(admix_proportions, coanc_subpops, weights = NULL)
}
\arguments{
\item{admix_proportions}{The \eqn{n \times k}{n-by-k} admixture proportion matrix}

\item{coanc_subpops}{Either the \eqn{k \times k}{k-by-k} intermediate subpopulation coancestry matrix (for the complete admixture model), or the length-\eqn{k} vector of intermediate subpopulation \eqn{F_{ST}}{FST} values (for the BN-PSD model), or a scalar \eqn{F_{ST}}{FST} value shared by all intermediate subpopulations.}

\item{weights}{The length-\eqn{n} vector of weights for individuals that define \eqn{F_{ST}}{FST} (default uniform weights)}
}
\value{
The \eqn{F_{ST}}{FST} of the admixed individuals
}
\description{
This function returns the \eqn{F_{ST}}{FST} of the admixed individuals given the admixture proportion matrix for \eqn{n} individuals and \eqn{k} intermediate subpopulations, the coancestry matrix of intermediate subpopulations (or its special cases, see \code{coanc_subpops} parameter below), and optional weights for individuals.
This \eqn{F_{ST}}{FST} equals the weighted mean of the diagonal of the coancestry matrix (see \code{\link{coanc_admix}}).
}
\examples{
# set desired parameters
# number of individuals
n_ind <- 1000
# number of intermediate subpopulations
k_subpops <- 10

# differentiation of intermediate subpopulations
coanc_subpops <- ( 1 : k_subpops ) / k_subpops

# construct admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# lastly, calculate Fst!!! (uniform weights in this case)
fst_admix(admix_proportions, coanc_subpops)

}
