% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/beliefPropagation-methods.R
\docType{methods}
\name{belief.propagation}
\alias{belief.propagation}
\alias{belief.propagation,InferenceEngine-method}
\alias{belief.propagation,InferenceEngine}
\title{perform belief propagation.}
\usage{
belief.propagation(ie, observations = NULL, return.potentials = FALSE)

\S4method{belief.propagation}{InferenceEngine}(ie, observations = NULL,
  return.potentials = FALSE)
}
\arguments{
\item{ie}{an \code{\link{InferenceEngine}} object.}

\item{observations}{list of observations, consisting in two vector, \code{observed.vars} for the observed variables,
and \code{observed.vals} for the values taken by variables listed in \code{observed.vars}. If no observations
are provided, the \code{InferenceEngine} will use the ones it already contains.}

\item{return.potentials}{if TRUE only the potentials are returned, instead of the default \code{\link{BN}}.}
}
\value{
updated \code{\link{InferenceEngine}} object.
}
\description{
Perform belief propagation for the network of an InferenceEngine, given a set of observations when present.
In the current version of \code{bnstruct}, belief propagation can be computed only over a junction tree.
}
\examples{
\dontrun{
dataset <- BNDataset("file.header", "file.data")
bn <- BN(dataset)
ie <- InferenceEngine(bn)
ie <- belief.propagation(ie)

observations(ie) <- list("observed.vars"=("A","G","X"), "observed.vals"=c(1,2,1))
belief.propagation(ie)
}

}
