% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bossa_Clust.R
\name{BossaClust}
\alias{BossaClust}
\title{Bossa Clustering}
\usage{
BossaClust(data, data.pre = NULL, alpha = 1, p = c(0.9, 0.75, 0.5),
  lin = 0.25, is.pca = TRUE, pca.sum.prop = 0.95, n.comp = 50,
  fix.pca.comp = FALSE, cri = 1, lintype = "ward.D2", perplexity = 30)
}
\arguments{
\item{data}{an original categorical data with n observations and p variables.}

\item{data.pre}{an list obtained by \code{\link{BossaSimi}} including original
categorical data, similarity matrix, dissimilarity matrix and transformed data,
Bossa scores. It is recommended to calculate the data.pre first and then do
\code{\link{BossaClust}} in order to save time when trying to change parameters
of this function.}

\item{alpha}{A power scaling for Bossa scores, representing the weight of
variable sigma value.}

\item{p}{A set of quantiles(90%, 75% and median) of the positive values of
similarity matrix to form clusters at different levels of within-cluster similarity.}

\item{lin}{A tuning parameter to control the size of each overlap cluster before
merging, smaller lin leads to larger cluster size.}

\item{is.pca}{A logical variable indicating if the Bossa scores should transformed
to principle components and then calculate the similarity matrix. It is recommended
when processing the ultra-dimension data.}

\item{pca.sum.prop}{A numeric indicating how many components should be reserved
in order to make this proportion of variance. The default is \code{pca.sum.prop =  0.95}.}

\item{n.comp}{The number of components of PCA. The default is \code{n.comp = 50}.}

\item{fix.pca.comp}{A numeric variable indicating whether choosing the fixed
number of components or the fixed proportion of variance and the default is to
choose fixed proportion.}

\item{cri}{A tuning parameter, if p value smaller than cri, then reject
the NULL hypothesis and merge overlap sub-clusters. And cri can be any numeric less
than \code{1}, if \code{cri = 1} then the criteria will be reset to \code{0.05/N}
(N is the number of all overlap sub-clusters), and if \code{cri = 2} then the
criteria \code{0.05/N(N-1)}.}

\item{lintype}{The agglomeration method to be used in \code{\link[stats]{hclust}}.
This should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2",
"single", "complete", "average" and so on. The default is "ward.D2".}

\item{perplexity}{A parameter of tsne}
}
\value{
An object including overlap clusters after merging and non-overlap
clusters, which can be showed by function \code{\link{bossa_interactive}}
}
\description{
With the previous calculated similarity matrix or the original categorical
dataframe, the results of both overlap clustering and hierarchical clustering
are obtained with several recommended cluster numbers(k) after processing the merge
cluster step.
}
\examples{
{
data(bo.simu.data)
object <- BossaClust(bo.simu.data)
}

}
