% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_formatting.R
\name{create_boinet_tables}
\alias{create_boinet_tables}
\title{Create Report-Ready Tables from BOIN-ET Results}
\usage{
create_boinet_tables(
  boinet_result,
  oc_title = "Operating Characteristics",
  design_title = "Design Parameters"
)
}
\arguments{
\item{boinet_result}{Result object from any boinet function}

\item{oc_title}{Title for operating characteristics table}

\item{design_title}{Title for design parameters table}
}
\value{
List containing formatted gt tables and tidy data
}
\description{
Generates publication-ready gt tables from boinet simulation results.
This is a convenience wrapper for format_boinet_results with gt_ready output.
}
\examples{
\dontrun{
result <- tite.boinet(...)
tables <- create_boinet_tables(result,
                              oc_title = "Trial Operating Characteristics",
                              design_title = "Design Specifications")

# Print tables
print(tables$oc_table)
print(tables$design_table)

# Save tables
tables$oc_table |> gt::gtsave("oc_results.html")
}
}
