% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightgbm.R
\name{train_lightgbm}
\alias{train_lightgbm}
\title{Boosted trees with lightgbm}
\usage{
train_lightgbm(
  x,
  y,
  max_depth = -1,
  num_iterations = 100,
  learning_rate = 0.1,
  feature_fraction = 1,
  min_data_in_leaf = 20,
  min_gain_to_split = 0,
  bagging_fraction = 1,
  early_stopping_rounds = NULL,
  validation = 0,
  counts = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{A data frame or matrix of predictors}

\item{y}{A vector (factor or numeric) or matrix (numeric) of outcome data.}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{num_iterations}{An integer for the number of boosting iterations.}

\item{learning_rate}{A numeric value between zero and one to control the learning rate.}

\item{feature_fraction}{Fraction of predictors that will be randomly sampled
at each split.}

\item{min_data_in_leaf}{A numeric value for the minimum sum of instances needed
in a child to continue to split.}

\item{min_gain_to_split}{A number for the minimum loss reduction required to make a
further partition on a leaf node of the tree.}

\item{bagging_fraction}{Subsampling proportion of rows.}

\item{early_stopping_rounds}{Number of iterations without an improvement in
the objective function occur before training should be halted.}

\item{validation}{The \emph{proportion} of the training data that are used for
performance assessment and potential early stopping.}

\item{counts}{A logical; should \code{feature_fraction} be interpreted as the
\emph{number} of predictors that will be randomly sampled at each split?
\code{TRUE} indicates that \code{mtry} will be interpreted in its sense as a \emph{count},
\code{FALSE} indicates that the argument will be interpreted in its sense as a
\emph{proportion}.}

\item{quiet}{A logical; should logging by \code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}} be muted?}

\item{...}{Other options to pass to \code{\link[lightgbm:lgb.train]{lightgbm::lgb.train()}}. Arguments
will be correctly routed to the \code{param} argument, or as a main argument,
depending on their name.}
}
\value{
A fitted \code{lightgbm.Model} object.
}
\description{
\code{train_lightgbm} is a wrapper for \code{lightgbm} tree-based models
where all of the model arguments are in the main function.
}
\details{
This is an internal function, not meant to be directly called by the user.
}
\keyword{internal}
