% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-s3.R
\name{predict.booami}
\alias{predict.booami}
\alias{predict.booami_cv}
\alias{predict.booami_pooled}
\alias{predict.booami_multi}
\title{Predict from booami objects}
\usage{
\method{predict}{booami_cv}(object, newdata, type = c("link", "response"), ...)

\method{predict}{booami_pooled}(object, newdata, type = c("link", "response"), ...)

\method{predict}{booami_multi}(object, newdata, type = c("link", "response"), ...)
}
\arguments{
\item{object}{A fitted booami object. One of:
\itemize{
\item \code{"booami_cv"} — cross-validated model object.
\item \code{"booami_pooled"} — pooled fit from \code{impu_boost(..., pool = TRUE)}.
\item \code{"booami_multi"} — unpooled fit from \code{impu_boost(..., pool = FALSE)}.
}}

\item{newdata}{A data.frame or matrix of predictors (same columns/order as training).}

\item{type}{Either \code{"link"} for the linear predictor, or \code{"response"} for
mean/probability (Gaussian/logistic respectively).}

\item{...}{Passed to \code{\link{booami_predict}}. For \code{"booami_multi"}, you may
use \code{aggregate = "mean"|"median"|NULL} and/or \code{which_m = <index>} to
control how predictions are aggregated across imputations.}
}
\value{
A numeric vector of predictions.
}
\description{
Predict responses (link or response scale) from fitted booami models.
}
\seealso{
\code{\link{booami_predict}}
}
