% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{bookdownplus}
\alias{bookdownplus}
\title{Create demo files for building books with R bookdown package.}
\usage{
bookdownplus(template = "thesis_classic",
  title = "R bookdownplus: Authoring varied types of books and documents with R bookdown",
  author = "Peng Zhao", from_address = "15 Robin Hood Lane",
  from_town = "11758  Massapequa, Long Island, New York",
  from_phone = "62762524", from_email = "dapengde@live.com",
  to_who = "receiver", to_address = "receiver address",
  to_town = "100000 Beijing, China", type = c("business", "personal")[2],
  fontsize = c("tiny", "scriptsize", "footnotesize", "small", "normalsize",
  "large", "Large", "LARGE", "huge", "Huge")[5], email = "pzhao@pzhao.net",
  institute = "Institute of Ecology, Univ. Innsbruck",
  longinstitute = "Institute of Ecology, University of Innsbruck, Austria",
  web = "pzhao.org", logo = "images/logo.png",
  backimg = "images/logo.png", bibliofiles = "bib/bib.bib",
  theme = c("eco", "ocean", "rose")[1])
}
\arguments{
\item{template}{character. Choose a template for your book or doc. The default template is 'thesis_classic'. Available templates are:
\itemize{
\item 'article', academic article,
\item 'article_zh', academic article in Chinese,
\item 'calendar',  monthly or weekly calendar,
\item 'chemistry',   book with chemical molecular formulae and equations
\item 'chemistry_zh', chemistry book in Chinese,
\item 'guitar',  book with guitar chords,
\item 'mail', personal or business mail,
\item 'journal', laboratory journal or personal diary,
\item 'yihui_mini',  a mini demo book by Yihui Xie,
\item 'yihui_demo',  the original demo book by Yihui Xie,
\item 'yihui_zh', the demo in Chinese by Yihui Xie,
\item 'article_mdpi',   academic article by mdpi,
\item 'thesis_classic' (default), classic thesis,
\item 'thesis_ubt',  thesis of University of Bayreuth,
\item 'thesis_zju',  thesis of Zhejiang Uni., in Chinese,
\item 'poster', poster,
\item 'poem', poem book.
}}

\item{title}{character. book title.}

\item{author}{character. book author.}

\item{from_address}{character. sender's address (Street and No.) for mail template}

\item{from_town}{character. sender's town for mail template}

\item{from_phone}{character. sender's phone number for mail templae}

\item{from_email}{character. sender's email for mail template}

\item{to_who}{character. receiver's name for mail template}

\item{to_address}{character. receiver's address (Street and No.) for mail template}

\item{to_town}{character. receiver's town for mail template}

\item{type}{character. The mail type for mail template. Available types are:
\itemize{
\item 'business',
\item 'personal' (default).
}}

\item{fontsize}{character. fontsize of the mail body for mail template. Available sizes are:
\itemize{
\item 'tiny',
\item 'scriptsize',
\item 'footnotesize',
\item 'small',
\item 'normalsize' (default),
\item 'large',
\item 'Large',
\item 'LARGE',
\item 'huge',
\item 'Huge'.
}}

\item{email}{character. author's email for poster template}

\item{institute}{character. for poster template}

\item{longinstitute}{character. for poster template}

\item{web}{character. for poster template}

\item{logo}{character. The path of the logo image. for poster template}

\item{backimg}{character. The path of the background image. for poster template}

\item{bibliofiles}{character. The path of the bib file for poster template}

\item{theme}{character. theme for poster template. available themes are
-'eco' (default),
-'ocean',
-'rose'.}
}
\value{
demo files to build with bookdown
}
\description{
Technically, \code{bookdownplus} is a collection and selector of R bookdown templates. \code{bookdownplus} helps you write academic journal articles, guitar books, chemical equations, mails, calendars, and diaries. R \code{bookdownplus} extends the features of \code{bookdown}, and simplifies the procedure. Users only have to choose a template, clarify the book title and author name, and then focus on writing the text. No need to struggle in YAML and LaTeX.

Full documentation of \code{bookdownplus} can be found in the book \href{https://bookdown.org/baydap/bookdownplus}{R bookdownplus Textbook}. Here is a quick-start procedure.
\itemize{
\item Before starting, you have to install \code{bookdown} package, and other software and packages (i.e. 'Pandoc', 'LaTeX', \code{rmarkdown}, \code{rticle}, \code{knitr}, etc.) which \code{bookdown} depends on. See the \href{https://bookdown.org/yihui/bookdown/}{official manual of bookdown} for details. Additionally, if you want to produce a poster, phython must be installed before using, and the path of phython might have to be added to the environmental variables for Windows users.
\item Run \code{bookdownplus()} and specify the template with \code{template} argument, You will get some files (e.g. \code{index.Rmd}, \code{body.Rmd}, \code{bookdownplus.Rproj}) and folders in your working directory. Although there are many other arguments for \code{bookdownplus()}, you can simply ignore them if you use \code{bookdownplus} package for the first time.
\item Open \code{bookdownplus.Rproj} with RStudio. Now press \code{ctrl+shift+b} to build it. Your will get a book file named \code{*.pdf} in \code{_book/} folder.
\item Write your own text in \code{index.Rmd} and \code{body.Rmd}, and build your own lovely book.
}
}
\examples{
bookdownplus()
bookdownplus(template = "article")
}
