% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esmbl_stability.R
\name{esmbl.stability}
\alias{esmbl.stability}
\title{Estimate the stability of a clustering based on non-parametric bootstrap 
out-of-bag scheme, with option for subsampling scheme}
\usage{
esmbl.stability(
  x,
  k,
  scheme = "kmeans",
  B = 100,
  hc.method = "ward.D",
  cut_ratio = 0.5,
  dist_method = "euclidean"
)
}
\arguments{
\item{x}{\code{data.frame} of the data set where rows are observations and columns are features}

\item{k}{number of clusters for which to estimate the stability}

\item{scheme}{clustering method to use ("kmeans", "hc", or "spectral")}

\item{B}{number of bootstrap re-samples}

\item{hc.method}{hierarchical clustering method (default: "ward.D")}

\item{cut_ratio}{ratio for subsampling (default: 0.5)}

\item{dist_method}{distance method for spectral clustering (default: "euclidean")}
}
\value{
\describe{
\item{membership}{vector of membership for each observation from the reference clustering}
\item{obs_wise}{vector of estimated observation-wise stability}
\item{clust_wise}{vector of estimated cluster-wise stability}
\item{overall}{numeric estimated overall stability}
\item{Smin}{numeric estimated Smin through out-of-bag scheme}
}
}
\description{
Estimate the stability of a clustering based on non-parametric bootstrap 
out-of-bag scheme, with option for subsampling scheme
}
\details{
This function estimates the stability through out-of-bag observations 
It estimate the stability at the 
(1) observation level, (2) cluster level, and (3) overall.
}
\examples{
\donttest{
set.seed(123)
data(iris)
df <- iris[,1:4]
result <- esmbl.stability(df, k=3, scheme="kmeans")
}

}
\author{
Tianmou Liu
}
