% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_ob.R
\name{ob.stability}
\alias{ob.stability}
\title{Estimate the stability of a clustering based on non-parametric bootstrap 
out-of-bag scheme, with option for subsampling scheme}
\usage{
ob.stability(x, k, B = 500, r = 5, subsample = FALSE, cut_ratio = 0.5)
}
\arguments{
\item{x}{\code{data.frame} of the data set where the rows as observations and columns as dimensions of features}

\item{k}{number of clusters for which to estimate the stability}

\item{B}{number of bootstrap re-samples}

\item{r}{integer parameter in the kmeansCBI() funtion}

\item{subsample}{logical parameter to use the subsampling scheme option in the resampling process (instead of bootstrap)}

\item{cut_ratio}{numeric parameter between 0 and 1 for subsampling scheme training set ratio}
}
\value{
\describe{
\item{\code{membership}}{\code{vector} of membership for each observation from the reference clustering}
\item{\code{obs_wise}}{\code{vector} of estimated observation-wise stability}
\item{\code{clust_wise}}{\code{vector} of estimated cluster-wise stability}
\item{\code{overall}}{\code{numeric} estimated overall stability}
\item{\code{Smin}}{\code{numeric} estimated Smin through out-of-bag scheme}
}
}
\description{
Estimate the stability of a clustering based on non-parametric bootstrap 
out-of-bag scheme, with option for subsampling scheme
}
\details{
This function estimates the stability through out-of-bag observations 
It estimate the stability at the 
(1) observation level, (2) cluster level, and (3) overall.
}
\examples{
\donttest{
set.seed(123)
data(iris)
df <- data.frame(iris[,1:4])
# You can choose to scale df before clustering by 
# df <- scale(df)
ob.stability(df, k = 2, B=500, r=5)
}

}
\references{
Bootstrapping estimates of stability for clusters, observations and model selection.
Han Yu, Brian Chapman, Arianna DiFlorio, Ellen Eischen, David Gotz, Matthews Jacob and Rachael Hageman Blair.
}
\author{
Tianmou Liu
}
