% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loaded.r
\name{path}
\alias{path}
\alias{base_path}
\alias{script_path}
\alias{knitr_path}
\alias{shiny_path}
\alias{testthat_path}
\title{Get a module’s path}
\usage{
path(mod)

base_path(mod)

script_path()

knitr_path()

shiny_path()

testthat_path()
}
\arguments{
\item{mod}{a module environment or namespace.}
}
\value{
\code{path} returns a character string containing the module’s full
path.

\code{base_path} returns a character string containing the module’s
base directory, or the current working directory if not invoked on a module.

\code{script_path} returns a character string that contains the
directory in which the calling R code is run. See \sQuote{Details}.

\code{knitr_path} returns the directory in which the currently knit
document is run, or \code{NULL} if not called from within a \pkg{knitr}
document.

\code{shiny_path} returns the directory in which a \pkg{Shiny}
application is running, or \code{NULL} if not called from within a
\pkg{Shiny} application.

\code{testthat_path} returns the directory in which \pkg{testthat}
code is being executed, or \code{NULL} if not called from within a
\pkg{testthat} test case.
}
\description{
The following functions retrieve information about the path of the directory
that a module or script is running in.
}
\details{
\code{script_path} takes a best guess at a script’s path, since R does not
provide a sure-fire way for determining the path of the currently executing
code. The following calling situations are covered:

\enumerate{
 \item Path explicitly set via \code{set_script_path}
 \item Path of a running document/application (\pkg{knitr}, \pkg{Shiny})
 \item Path of unit test cases (\pkg{testthat})
 \item Path of the currently opened source code file in RStudio
 \item Code invoked as \command{Rscript script.r}
 \item Code invoked as \command{R CMD BATCH script.r}
 \item Script run interactively (use \code{getwd()})
}
}
\keyword{internal}
