% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.r
\name{map}
\alias{map}
\alias{flatmap}
\alias{flatmap_chr}
\alias{vmap}
\alias{map_int}
\alias{map_lgl}
\alias{map_chr}
\alias{transpose}
\title{Apply function to elements in list}
\usage{
map(.f, ...)

flatmap(.f, ..., .default)

flatmap_chr(.f, ...)

vmap(.f, .x, ..., .default)

map_int(.f, ...)

map_lgl(.f, ...)

map_chr(.f, ...)

transpose(...)
}
\arguments{
\item{.f}{an n-ary function where n is the number of further arguments given}

\item{\dots}{lists of arguments to map over in parallel}

\item{.default}{the default value returned by \code{flatmap} for an empty
input}
}
\value{
\code{map} returns a (potentially nested) list of values resulting
from applying \code{.f} to the arguments.

\code{flatmap} returns a vector with type given by \code{.default},
or \code{.default}, if the input is empty.

\code{transpose} returns a list of the element-wise concatenated
input vectors; that is, a \dQuote{transposed list} of those elements.
}
\description{
\code{map} applies a function to lists of arguments, similar to \code{Map} in
base R, with the argument \code{USE.NAMES} set to \code{FALSE}.
\code{flatmap} performs a recursive map: the return type is always a vector
of some type given by the \code{.default}, and if the return value of calling
\code{.f} is a vector, it is flattened into the enclosing vector (see
\sQuote{Examples}).
\code{transpose} is a special \code{map} application that concatenates its
inputs to compute a transposed list.
}
\section{Examples}{

\preformatted{
flatmap_chr(identity, NULL)
# character(0)

flatmap_chr(identity, c('a', 'b'))
# [1] "a" "b"

flatmap_chr(identity, list(c('a', 'b'), 'c'))
# [1] "a" "b" "c"

transpose(1 : 2, 3 : 4)
# [[1]]
# [1] 1 3
#
# [[2]]
# [1] 2 4
}
}

\keyword{internal}
