% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.boxcox.R
\name{optim.boxcox}
\alias{optim.boxcox}
\title{Response Transformations for Random Effect and Variance Component Models}
\usage{
optim.boxcox(
  formula,
  groups = 1,
  data,
  K = 3,
  steps = 500,
  tol = 0.5,
  start = "gq",
  EMdev.change = 1e-04,
  find.in.range = c(-3, 3),
  s = 60,
  plot.opt = 3,
  verbose = FALSE,
  noformat = FALSE,
  ...
)
}
\arguments{
\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{groups}{the random effects. To fit overdispersion models, set \code{groups} = 1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{K}{the number of mass points.}

\item{steps}{maximum number of iterations for the EM algorithm.}

\item{tol}{a positive scalar (usually, 0<\code{tol} <= 2)}

\item{start}{a description of the initial values to be used in the fitted
model, Quantile-based version "quantile" or Gaussian Quadrature "gq" can be
set.}

\item{EMdev.change}{a small scalar, with default 0.0001, used to determine
when to stop EM algorithm.}

\item{find.in.range}{search in a range of \code{lambda}, with default (-3,3)
in step of 0.1.}

\item{s}{number of points in the grid search of \code{lambda}.}

\item{plot.opt}{Set \code{plot.opt=3}, to plot the disparity against
iteration number and the profile log-likelihood against \code{lambda}. 
Use \code{plot.opt=0}, to only plot the profile log-likelihood against \code{lambda}.}

\item{verbose}{If set to FALSE, no printed output on progress.}

\item{noformat}{Set \code{noformat = TRUE}, to change the formatting of the plots.}

\item{\dots}{extra arguments will be ignored.}
}
\value{
List with class \code{boxcoxmix} containing:
\item{All.lambda}{list of \code{lambda} values used in the grid.}
\item{Maximum}{the best estimate of \code{lambda} found.} \item{objective}{the value of the profile
log-likelihood corresponding to Maximum.} 
\item{EMconverged}{1 is TRUE, means the EM algorithm converged.} \item{EMiteration}{provides the number of iterations of the EM algorithm.} 
\item{mass.point}{the fitted mass points.} \item{p}{the masses corresponding to the mixing proportions.} \item{beta}{the
vector of coefficients.} \item{sigma}{the standard deviation of the mixing distribution (the square root of the variance).} \item{se}{the standard error of the estimate.}
\item{w}{a matrix of posterior probabilities that element i comes from cluster k.}
\item{loglik}{the profile log-likelihood of the fitted regression model.}
\item{profile.loglik}{the profile complete log-likelihood of the fitted regression model.}
\item{disparity}{the disparity of the fitted regression model.} 
\item{call}{the matched call.} \item{formula}{the formula provided.}
\item{data}{the data argument.} \item{aic}{the Akaike information criterion of the fitted regression model.}
\item{fitted}{the fitted values for the individual observations.} \item{fitted.transformed}{the fitted values for
the individual transformed observations.} \item{residuals}{the difference between the observed values and the fitted values.}
\item{residuals.transformed}{the difference between the transformed observed values and the transformed fitted values.}
\item{predicted.re}{a vector of predicted residuals.}

The other outcomes are not relevant to users and they are intended for internal use only.
}
\description{
The \code{optim.boxcox()} performs a grid search over the parameter \code{lambda}
for overdispersed generalized linear models and variance component models and 
then optimizes over this grid, to calculate the maximum likelihood estimator of
the transformation.
}
\details{
The Box-Cox transformation (Box & Cox, 1964) is applied to the overdispersed
generalized linear models and variance component models with an unspecified
mixing distribution. The NPML estimate of the mixing distribution is known
to be a discrete distribution involving a finite number of mass-points and corresponding
masses (Aitkin et al., 2009). An Expectation-Maximization (EM) algorithm is
used for fitting the finite mixture distribution, one needs to specify the
number of components \code{K} of the finite mixture in advance. To stop the EM-algorithm when it reached its convergence point,
we need to defined the convergence criteria that is the absolute change in 
the successive log-likelihood function values being less than an arbitrary 
parameter such as \code{EMdev.change} = 0.0001 (Einbeck et
at., 2014). This algorithm can be implemented using
the function \code{np.boxcoxmix()}, which is designed to account for overdispersed generalized
linear models and variance component models using the non-parametric
profile maximum likelihood (NPPML) estimation.

 
The ability of the EM algorithm to locate the global maximum in fewer iterations
can be affected by the choice of initial values, the function \code{optim.boxcox()} 
allows us to choose from two different methods to set the initial value of the mass
points. When option "gq" is set, then Gauss-Hermite masses and mass points are used
as starting points in the EM algorithm, while setting start= "quantile" uses the 
Quantile-based version to select the starting points. 


\code{optim.boxcox()} performs a grid search over the parameter \code{lambda} and then
optimizes over this grid, to calculate the maximum likelihood estimator of the transformation.
It produces a plot of the non-parametric profile likelihood function that summarises information
concerning \code{lambda}, including a vertical line indicating the best value of \code{lambda}
that maximizes the non-parametric profile log-likelihood.
}
\examples{
# The strength Data
data(strength, package = "mdscore")
maxlam <- optim.boxcox(y ~ cut*lot, data = strength, K = 3,  
           start = "gq" ,  find.in.range = c(-2, 2), s = 5)
# Maximum profile log-likelihood: 33.6795 at lambda= -0.4  

\donttest{data(Oxboys, package = "nlme")
Oxboys$boy <- gl(26,9)
maxlamvc <- optim.boxcox(height ~  age, groups = Oxboys$boy,
                         data = Oxboys,   K = 2,  start = "gq",
                         find.in.range=c(-1.2,1), s=6, plot.opt = 0) 
maxlamvc$Maximum
#[1] -0.8333333
plot(maxlamvc,8)}





}
\references{
Box G. and Cox D. (1964). An analysis of transformations. Journal of
the Royal Statistical Society. Series B (Methodological), pages 211-252.

Aitkin, M. A., Francis, B., Hinde, J., and Darnell, R. (2009). Statistical
modelling in R. Oxford University Press Oxford.

Jochen Einbeck, Ross Darnell and John Hinde (2014). npmlreg:
Nonparametric maximum likelihood estimation for random effect
models. R package version 0.46-1.
}
\seealso{
\code{\link{np.boxcoxmix}},
\code{\link{tolfind.boxcox}}.
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{boxcox}
\keyword{optim}
