% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_search.R
\name{box_search}
\alias{box_search}
\alias{box_search_files}
\alias{box_search_folders}
\alias{box_search_trash}
\title{Search Box files}
\usage{
box_search(
  query = "",
  content_types = c("name", "description", "file_content", "comments", "tags"),
  type = NULL,
  file_extensions = NULL,
  ancestor_folder_ids = NULL,
  created_at_range = NULL,
  updated_at_range = NULL,
  size_range = NULL,
  trash = FALSE,
  owner_user_ids = NULL,
  max = 200
)

box_search_files(query, ...)

box_search_folders(query, ...)

box_search_trash(query, ...)
}
\arguments{
\item{query}{\code{character}, search term.}

\item{content_types}{\code{character}, content to search; more than one
can be supplied with a vector.}

\item{type}{\code{character}, type of object to return; the default,
\code{NULL}, returns all possible types (\code{"file"}, \code{"folder"}, or \code{"weblink"}).}

\item{file_extensions}{\code{character}, vector of strings containing the file
extensions (without dots) by which to narrow your search.}

\item{ancestor_folder_ids}{\code{numeric} or \code{character}, if supplied,
results are limited to one or more parent (ancestor) folders.}

\item{created_at_range}{\code{POSIXct} (vector, length 2),
range of created-at times.}

\item{updated_at_range}{\code{POSIXct} (vector, length 2),
range of updated-at times.}

\item{size_range}{\code{numeric} (vector, length 2),
range of file sizes (bytes).}

\item{trash}{\code{logical}, indicates to search only the trash folder.}

\item{owner_user_ids}{\code{numeric} or \code{character}, limits search to files owned
by users with these IDs.}

\item{max}{\code{numeric}, upper limit on the number of search results.}

\item{...}{Other arguments passed to \code{box_search()}.}
}
\value{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_object_list}}.
}
\description{
Search Box files
}
\details{
The Box API supports a maximum of 200 results per request. If
\code{max > 200}, then multiple requests will be sent to retrieve and
combine 'paginated' results for you, behind the scenes.

See the \href{https://support.box.com/hc/en-us/articles/360043696314-Search-for-Files-Folders-and-Content}{box.com search description}
for details of the features of the service.
Some notable details:
\itemize{
\item Full-text searching is the default
\itemize{
\item available for many source code file types, but not R scripts.
\item by default Box seaches by word/token and uses the \code{OR} operation e.g.
\code{box_search("this that")} is equivilant to \code{box_search("this OR that")}
}
\item Reserved words for boolean operations
\itemize{
\item \code{AND}, \code{OR}, and \code{NOT} (uppercase only) are interpreted as special context e.g.
\code{box_search("NOT this")}, \code{box_search("this AND that")}
}
\item Exact phrases can be matched
\itemize{
\item by surrounding them with double quotation marks e.g.
\code{box_search('"this exact phrase"')} or \verb{box_search("\\"this exact phrase\\"")}
}
\item Searchability is not instantaneous
\itemize{
\item it can take >10 minutes for a newly uploaded file to become findable
}
}
}
