% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_range.R
\name{bp_range}
\alias{bp_range}
\title{Blood Pressure Range}
\usage{
bp_range(data, inc_date = FALSE, subj = NULL, add_groups = NULL)
}
\arguments{
\item{data}{Required dataframe with SBP and DBP columns corresponding to
Systolic and Diastolic BP. This dataframe should come from \code{data_process}}

\item{inc_date}{Optional argument. Default is FALSE. As ABPM data typically
overlaps due to falling asleep on one date and waking up on another, the \code{inc_date}
argument is typically kept as FALSE, but the function will work regardless. Setting
\code{inc_date = TRUE} will include these dates as a grouping level.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{add_groups}{Optional argument. Allows the user to aggregate the data by an
additional "group" to further refine the output. The supplied input must be a
character vector with the strings corresponding to existing column names of the
processed \code{data} input supplied. Capitalization of \code{add_groups} does not matter.
Ex: \code{add_groups = c("Time_of_Day")}}
}
\value{
A tibble with SBP_max, SBP_min, SBP_range, DBP_max, DBP_min, DBP_range
and any additional optional columns included in data such as \code{ID}, \code{VISIT},
\code{WAKE}, and \code{DATE}. If inc_date = TRUE, each row will correspond to a date.
The resulting tibble consists of:
\itemize{

   \item \code{ID}: The unique identifier of the subject. For single-subject datasets, ID = 1
   \item \code{VISIT}: (If applicable) Corresponds to the visit # of the subject, if more than 1
   \item \code{WAKE}: (If applicable) Corresponds to the awake status of the subject (0 = asleep |
   1 = awake)
   \item \code{SBP_max} / \code{DBP_max}: Finds the maximum value for the given grouping granularity
   \item \code{SBP_min} / \code{DBP_min}: Finds the minimum value for the given grouping granularity
   \item \code{SBP_range} / \code{DBP_range}: Calculates the range between the max and min values
   \item \code{N}: The number of observations for that particular grouping. If \code{inc_date = TRUE},
   \code{N} corresponds to the number of observations for that date. If \code{inc_date = FALSE},
   \code{N} corresponds to the number of observations for the most granular grouping available
   (i.e. a combination of \code{ID}, \code{VISIT}, and \code{WAKE})
   \item Any add_groups variables supplied to function argument will be present as a column in the
   resulting tibble.

}
}
\description{
Calculates the range (max - min) of both SBP and DBP values in addition to max and
min values for reference with the option to specify date as an additional level
of granularity
}
\examples{
# Load hypnos_data
data(hypnos_data)
data(bp_jhs)

# Process hypnos_data
hypnos_proc <- process_data(hypnos_data, sbp = "SYST", dbp = "DIAST", bp_datetime = "date.time",
id = "id", wake = "wake", visit = "visit", hr = "hr", pp ="pp", map = "map", rpp = "rpp")
# Process bp_jhs data
jhs_proc <- process_data(bp_jhs, sbp = "Sys.mmHg.", dbp = "Dias.mmHg.", bp_datetime = "DateTime",
hr = "Pulse.bpm.")

# Calculate BP range
bp_range(hypnos_proc)
bp_range(jhs_proc, inc_date = TRUE, add_groups = c("meal_time"))
# Notice that meal_time is not a column from process_data, but it still works
}
