% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{covariateEffect_or1}
\alias{covariateEffect_or1}
\title{Covariate effect for Bayesian quantile regression for ordinal quantile model
with more than 3 outcomes}
\usage{
covariateEffect_or1(model, y, x, modX, p)
}
\arguments{
\item{model}{outcome of the ORI (quantreg_or1) model.}

\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.
If the covariate of interest is continuous, then the column for the covariate of interest remains unchanged.
If it is an indicator variable then replace the column for the covariate of interest with a
column of zeros.}

\item{modX}{matrix x with suitable modification to an independent variable including a column of ones with
or without column names. If the covariate of interest is continuous, then add the incremental change
to each observation in the column for the covariate of interest. If the covariate is an indicator variable,
then replace the column for the covariate of interest with a column of ones.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components:
\itemize{
\item{\code{avgDiffProb}: }{vector with change in predicted
probabilities for each outcome category.}
}
}
\description{
This function computes the average covariate effect for different
outcomes of the ORI model at the specified quantiles. The covariate
effects are calculated marginally of the parameters and the remaining covariates.
}
\details{
This function computes the average covariate effect for different
outcomes of the ORI model at the specified quantiles. The covariate
effects are calculated marginally of the parameters and the remaining covariates. The computation of covariate effects utilizes
the MCMC outputs from estimation.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 30, p = 0.25, tune = 1, display = FALSE)
modX <- x
modX[,3] <- modX[,3] + 0.02
res <- covariateEffect_or1(output, y, x, modX, p = 0.25)

# Summary of Covariate Effect:

#               Covariate Effect
# Category_1          -0.0076
# Category_2          -0.0014
# Category_3          -0.0010
# Category_4           0.0100

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics,
23: 115–156. DOI: 10.1016/S0731-9053(08)23004-5

Jeliazkov, I. and Rahman, M. A. (2012). “Binary and Ordinal Data Analysis
in Economics: Modeling and Estimation” in Mathematical Modeling with Multidisciplinary
Applications, edited by X.S. Yang, 123-150. John Wiley & Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
}
