% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data25j4}
\alias{data25j4}
\title{Simulated data from OR1 model for \eqn{p = 0.25} (i.e., 25th quantile)}
\usage{
data(data25j4)
}
\value{
Returns a list with components
\itemize{
\item{\code{x}: }{a matrix of covariates, including a column of ones.}
\item{\code{y}: }{a column vector of ordinal outcomes.}
}
}
\description{
Simulated data from OR1 model for \eqn{p = 0.25} (i.e., 25th quantile)
}
\details{
This data contains 500 observations generated from a quantile
ordinal model with 4 outcomes at the 25th quantile (i.e., \eqn{p = 0.25}).
The model specifics for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
\eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}). The cut-points \eqn{(0, 2, 4)} are used to classify the
continuous values of the dependent variable into 4 categories, which forms the ordinal outcomes.
}
\references{
Kozumi, H., and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
 Journal of Statistical Computation and Simulation, 81(11), 1565–1578. DOI: 10.1080/00949655.2010.496117

Yu, K., and Zhang, J. (2005). “A Three-Parameter Asymmetric
Laplace Distribution.” Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
}
\seealso{
\link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
}
\keyword{datasets}
