library(braggR)

test_that("Expected errors have been found.",{
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, NA), 0.5))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 2), 0.5))
            expect_error(sample_aggregator(c(1), 0.5))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), -1))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), 2))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), NA))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), alpha = -1, beta = 2))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), alpha =  1, beta = -2))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), alpha =  1, beta = 0))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), alpha =  1, beta = NA))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), alpha =  NA, beta = 1))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 0))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = NA))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = NULL))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, burnin = 200))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, burnin = -2))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, burnin = NA))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, thin = 100))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, thin = -1))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, num_sample = 100, thin = NA))
            expect_error(sample_aggregator(c(0.0625, 0.3125, 0.1250, 0.3125, 0.1875), p0 = 0.5, a = -1, b = 2))
})
