% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsep.R
\name{bsep}
\alias{bsep}
\title{Tries to identify the separator / delimiter used in a table format file}
\usage{
bsep(file, ntries = 10, separators = c(";", "\\t", " ", "|", ":", ","))
}
\arguments{
\item{file}{String. Name or full path to a file compatible with data.table::fread()}

\item{ntries}{Numeric. Number of rows to check for}

\item{separators}{Vector of strings. Additional uncommon delimiter to check for}
}
\value{
A string
}
\description{
The function reads the first row and tests the following common separators by default:
\code{';' '\\t' ' ' '|' ':' ','}
}
\examples{
file <- system.file('extdata', 'test.csv', package = 'bread')
## Checking the delimiter on the first 12 rows, including headers
bsep(file = file, ntries = 12)
}
